/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.support;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.statemachine.event.StateMachineEventPublisher;
import org.springframework.util.Assert;

public class StateMachineContextUtils {
    public static final String CONVERSION_SERVICE_BEAN_NAME = "cloudClusterConversionService";
    public static final String EVALUATION_CONTEXT_BEAN_NAME = "cloudClusterEvaluationContext";

    public static ConversionService getConversionService(BeanFactory beanFactory) {
        return StateMachineContextUtils.getBeanOfType(beanFactory, CONVERSION_SERVICE_BEAN_NAME, ConversionService.class);
    }

    public static StandardEvaluationContext getEvaluationContext(BeanFactory beanFactory) {
        return StateMachineContextUtils.getBeanOfType(beanFactory, EVALUATION_CONTEXT_BEAN_NAME, StandardEvaluationContext.class);
    }

    public static StateMachineEventPublisher getEventPublisher(BeanFactory beanFactory) {
        return StateMachineContextUtils.getBeanOfType(beanFactory, "stateMachineEventPublisher", StateMachineEventPublisher.class);
    }

    private static <T> T getBeanOfType(BeanFactory beanFactory, String beanName, Class<T> type) {
        Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null");
        if (!beanFactory.containsBean(beanName)) {
            return null;
        }
        return (T)beanFactory.getBean(beanName, type);
    }
}

