/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.support;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.core.OrderComparator;
import org.springframework.messaging.Message;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.event.StateMachineEventPublisher;
import org.springframework.statemachine.listener.CompositeStateMachineListener;
import org.springframework.statemachine.listener.StateMachineListener;
import org.springframework.statemachine.monitor.CompositeStateMachineMonitor;
import org.springframework.statemachine.processor.StateMachineHandlerCallHelper;
import org.springframework.statemachine.state.State;
import org.springframework.statemachine.support.LifecycleObjectSupport;
import org.springframework.statemachine.support.StateMachineContextUtils;
import org.springframework.statemachine.support.StateMachineInterceptor;
import org.springframework.statemachine.support.StateMachineInterceptorList;
import org.springframework.statemachine.transition.Transition;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public abstract class StateMachineObjectSupport<S, E>
extends LifecycleObjectSupport
implements BeanNameAware {
    private static final Log log = LogFactory.getLog(StateMachineObjectSupport.class);
    private final CompositeStateMachineListener<S, E> stateListener = new CompositeStateMachineListener();
    private final CompositeStateMachineMonitor<S, E> stateMachineMonitor = new CompositeStateMachineMonitor();
    private volatile StateMachineEventPublisher stateMachineEventPublisher;
    private boolean contextEventsEnabled = true;
    private final StateMachineInterceptorList<S, E> interceptors = new StateMachineInterceptorList();
    private String beanName;
    private volatile boolean handlersInitialized;
    private final StateMachineHandlerCallHelper<S, E> stateMachineHandlerCallHelper = new StateMachineHandlerCallHelper();

    protected void doStart() {
        if (!this.handlersInitialized) {
            try {
                this.stateMachineHandlerCallHelper.setBeanFactory(this.getBeanFactory());
                this.stateMachineHandlerCallHelper.afterPropertiesSet();
            }
            catch (Exception e) {
                log.error((Object)"Unable to initialize annotation handlers", (Throwable)e);
            }
            finally {
                this.handlersInitialized = true;
            }
        }
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    protected String getBeanName() {
        return this.beanName;
    }

    protected StateMachineEventPublisher getStateMachineEventPublisher() {
        if (this.stateMachineEventPublisher == null && this.getBeanFactory() != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("getting stateMachineEventPublisher service from bean factory " + this.getBeanFactory()));
            }
            this.stateMachineEventPublisher = StateMachineContextUtils.getEventPublisher(this.getBeanFactory());
        }
        return this.stateMachineEventPublisher;
    }

    public void setStateMachineEventPublisher(StateMachineEventPublisher stateMachineEventPublisher) {
        Assert.notNull((Object)stateMachineEventPublisher, (String)"StateMachineEventPublisher cannot be null");
        this.stateMachineEventPublisher = stateMachineEventPublisher;
    }

    public void setContextEventsEnabled(boolean contextEventsEnabled) {
        this.contextEventsEnabled = contextEventsEnabled;
    }

    protected CompositeStateMachineListener<S, E> getStateListener() {
        return this.stateListener;
    }

    protected CompositeStateMachineMonitor<S, E> getStateMachineMonitor() {
        return this.stateMachineMonitor;
    }

    protected void notifyStateChanged(StateContext<S, E> stateContext) {
        try {
            StateMachineEventPublisher eventPublisher;
            this.stateMachineHandlerCallHelper.callOnStateChanged(this.getBeanName(), stateContext);
            this.stateMachineHandlerCallHelper.callOnStateChanged(stateContext.getStateMachine().getId(), stateContext);
            this.stateListener.stateChanged(stateContext.getSource(), stateContext.getTarget());
            this.stateListener.stateContext(stateContext);
            if (this.contextEventsEnabled && (eventPublisher = this.getStateMachineEventPublisher()) != null) {
                eventPublisher.publishStateChanged(this, stateContext.getSource(), stateContext.getTarget());
            }
        }
        catch (Throwable e) {
            log.warn((Object)"Error during notifyStateChanged", e);
        }
    }

    protected void notifyStateEntered(StateContext<S, E> stateContext) {
        try {
            StateMachineEventPublisher eventPublisher;
            this.stateMachineHandlerCallHelper.callOnStateEntry(this.getBeanName(), stateContext);
            this.stateMachineHandlerCallHelper.callOnStateEntry(stateContext.getStateMachine().getId(), stateContext);
            this.stateListener.stateEntered(stateContext.getTarget());
            this.stateListener.stateContext(stateContext);
            if (this.contextEventsEnabled && (eventPublisher = this.getStateMachineEventPublisher()) != null) {
                eventPublisher.publishStateEntered(this, stateContext.getTarget());
            }
        }
        catch (Throwable e) {
            log.warn((Object)"Error during notifyStateEntered", e);
        }
    }

    protected void notifyStateExited(StateContext<S, E> stateContext) {
        try {
            StateMachineEventPublisher eventPublisher;
            this.stateMachineHandlerCallHelper.callOnStateExit(this.getBeanName(), stateContext);
            this.stateMachineHandlerCallHelper.callOnStateExit(stateContext.getStateMachine().getId(), stateContext);
            this.stateListener.stateExited(stateContext.getSource());
            this.stateListener.stateContext(stateContext);
            if (this.contextEventsEnabled && (eventPublisher = this.getStateMachineEventPublisher()) != null) {
                eventPublisher.publishStateExited(this, stateContext.getSource());
            }
        }
        catch (Throwable e) {
            log.warn((Object)"Error during notifyStateExited", e);
        }
    }

    protected void notifyEventNotAccepted(StateContext<S, E> stateContext) {
        try {
            StateMachineEventPublisher eventPublisher;
            this.stateMachineHandlerCallHelper.callOnEventNotAccepted(this.getBeanName(), stateContext);
            this.stateMachineHandlerCallHelper.callOnEventNotAccepted(stateContext.getStateMachine().getId(), stateContext);
            this.stateListener.eventNotAccepted(stateContext.getMessage());
            this.stateListener.stateContext(stateContext);
            if (this.contextEventsEnabled && (eventPublisher = this.getStateMachineEventPublisher()) != null) {
                eventPublisher.publishEventNotAccepted(this, stateContext.getMessage());
            }
        }
        catch (Throwable e) {
            log.warn((Object)"Error during notifyEventNotAccepted", e);
        }
    }

    protected void notifyTransitionStart(StateContext<S, E> stateContext) {
        try {
            StateMachineEventPublisher eventPublisher;
            this.stateMachineHandlerCallHelper.callOnTransitionStart(this.getBeanName(), stateContext);
            this.stateMachineHandlerCallHelper.callOnTransitionStart(stateContext.getStateMachine().getId(), stateContext);
            this.stateListener.transitionStarted(stateContext.getTransition());
            this.stateListener.stateContext(stateContext);
            if (this.contextEventsEnabled && (eventPublisher = this.getStateMachineEventPublisher()) != null) {
                eventPublisher.publishTransitionStart(this, stateContext.getTransition());
            }
        }
        catch (Throwable e) {
            log.warn((Object)"Error during notifyTransitionStart", e);
        }
    }

    protected void notifyTransition(StateContext<S, E> stateContext) {
        try {
            StateMachineEventPublisher eventPublisher;
            this.stateMachineHandlerCallHelper.callOnTransition(this.getBeanName(), stateContext);
            this.stateMachineHandlerCallHelper.callOnTransition(stateContext.getStateMachine().getId(), stateContext);
            this.stateListener.transition(stateContext.getTransition());
            this.stateListener.stateContext(stateContext);
            if (this.contextEventsEnabled && (eventPublisher = this.getStateMachineEventPublisher()) != null) {
                eventPublisher.publishTransition(this, stateContext.getTransition());
            }
        }
        catch (Throwable e) {
            log.warn((Object)"Error during notifyTransition", e);
        }
    }

    protected void notifyTransitionEnd(StateContext<S, E> stateContext) {
        try {
            StateMachineEventPublisher eventPublisher;
            this.stateMachineHandlerCallHelper.callOnTransitionEnd(this.getBeanName(), stateContext);
            this.stateMachineHandlerCallHelper.callOnTransitionEnd(stateContext.getStateMachine().getId(), stateContext);
            this.stateListener.transitionEnded(stateContext.getTransition());
            this.stateListener.stateContext(stateContext);
            if (this.contextEventsEnabled && (eventPublisher = this.getStateMachineEventPublisher()) != null) {
                eventPublisher.publishTransitionEnd(this, stateContext.getTransition());
            }
        }
        catch (Throwable e) {
            log.warn((Object)"Error during notifyTransitionEnd", e);
        }
    }

    protected void notifyStateMachineStarted(StateContext<S, E> stateContext) {
        try {
            StateMachineEventPublisher eventPublisher;
            this.stateMachineHandlerCallHelper.callOnStateMachineStart(this.getBeanName(), stateContext);
            this.stateMachineHandlerCallHelper.callOnStateMachineStart(stateContext.getStateMachine().getId(), stateContext);
            this.stateListener.stateMachineStarted(stateContext.getStateMachine());
            this.stateListener.stateContext(stateContext);
            if (this.contextEventsEnabled && (eventPublisher = this.getStateMachineEventPublisher()) != null) {
                eventPublisher.publishStateMachineStart(this, stateContext.getStateMachine());
            }
        }
        catch (Throwable e) {
            log.warn((Object)"Error during notifyStateMachineStarted", e);
        }
    }

    protected void notifyStateMachineStopped(StateContext<S, E> stateContext) {
        try {
            StateMachineEventPublisher eventPublisher;
            this.stateMachineHandlerCallHelper.callOnStateMachineStop(this.getBeanName(), stateContext);
            this.stateMachineHandlerCallHelper.callOnStateMachineStop(stateContext.getStateMachine().getId(), stateContext);
            this.stateListener.stateMachineStopped(stateContext.getStateMachine());
            this.stateListener.stateContext(stateContext);
            if (this.contextEventsEnabled && (eventPublisher = this.getStateMachineEventPublisher()) != null) {
                eventPublisher.publishStateMachineStop(this, stateContext.getStateMachine());
            }
        }
        catch (Throwable e) {
            log.warn((Object)"Error during notifyStateMachineStopped", e);
        }
    }

    protected void notifyStateMachineError(StateContext<S, E> stateContext) {
        try {
            StateMachineEventPublisher eventPublisher;
            this.stateMachineHandlerCallHelper.callOnStateMachineError(this.getBeanName(), stateContext);
            this.stateMachineHandlerCallHelper.callOnStateMachineError(stateContext.getStateMachine().getId(), stateContext);
            this.stateListener.stateMachineError(stateContext.getStateMachine(), stateContext.getException());
            this.stateListener.stateContext(stateContext);
            if (this.contextEventsEnabled && (eventPublisher = this.getStateMachineEventPublisher()) != null) {
                eventPublisher.publishStateMachineError(this, stateContext.getStateMachine(), stateContext.getException());
            }
        }
        catch (Throwable e) {
            log.warn((Object)"Error during notifyStateMachineError", e);
        }
    }

    protected void notifyExtendedStateChanged(Object key, Object value, StateContext<S, E> stateContext) {
        try {
            StateMachineEventPublisher eventPublisher;
            this.stateMachineHandlerCallHelper.callOnExtendedStateChanged(this.getBeanName(), key, value, stateContext);
            this.stateMachineHandlerCallHelper.callOnExtendedStateChanged(stateContext.getStateMachine().getId(), key, value, stateContext);
            this.stateListener.extendedStateChanged(key, value);
            this.stateListener.stateContext(stateContext);
            if (this.contextEventsEnabled && (eventPublisher = this.getStateMachineEventPublisher()) != null) {
                eventPublisher.publishExtendedStateChanged(this, key, value);
            }
        }
        catch (Throwable e) {
            log.warn((Object)"Error during notifyExtendedStateChanged", e);
        }
    }

    protected void notifyTransitionMonitor(StateMachine<S, E> stateMachine, Transition<S, E> transition, long duration) {
        try {
            this.stateMachineMonitor.transition(stateMachine, transition, duration);
        }
        catch (Exception e) {
            log.warn((Object)"Error during notifyTransitionMonitor", (Throwable)e);
        }
    }

    protected void notifyActionMonitor(StateMachine<S, E> stateMachine, Function<StateContext<S, E>, Mono<Void>> action, long duration) {
        try {
            this.stateMachineMonitor.action(stateMachine, action, duration);
        }
        catch (Exception e) {
            log.warn((Object)"Error during notifyTransitionMonitor", (Throwable)e);
        }
    }

    protected StateMachineInterceptorList<S, E> getStateMachineInterceptors() {
        return this.interceptors;
    }

    protected void setStateMachineInterceptors(List<StateMachineInterceptor<S, E>> interceptors) {
        Collections.sort(interceptors, new OrderComparator());
        this.interceptors.set(interceptors);
    }

    protected class StateMachineListenerRelay
    implements StateMachineListener<S, E> {
        protected StateMachineListenerRelay() {
        }

        @Override
        public void stateChanged(State<S, E> from, State<S, E> to) {
            StateMachineObjectSupport.this.stateListener.stateChanged(from, to);
        }

        @Override
        public void stateEntered(State<S, E> state) {
            StateMachineObjectSupport.this.stateListener.stateEntered(state);
        }

        @Override
        public void stateExited(State<S, E> state) {
            StateMachineObjectSupport.this.stateListener.stateExited(state);
        }

        @Override
        public void eventNotAccepted(Message<E> event) {
            StateMachineObjectSupport.this.stateListener.eventNotAccepted(event);
        }

        @Override
        public void transition(Transition<S, E> transition) {
            StateMachineObjectSupport.this.stateListener.transition(transition);
        }

        @Override
        public void transitionStarted(Transition<S, E> transition) {
            StateMachineObjectSupport.this.stateListener.transitionStarted(transition);
        }

        @Override
        public void transitionEnded(Transition<S, E> transition) {
            StateMachineObjectSupport.this.stateListener.transitionEnded(transition);
        }

        @Override
        public void stateMachineStarted(StateMachine<S, E> stateMachine) {
            StateMachineObjectSupport.this.stateListener.stateMachineStarted(stateMachine);
        }

        @Override
        public void stateMachineStopped(StateMachine<S, E> stateMachine) {
            StateMachineObjectSupport.this.stateListener.stateMachineStopped(stateMachine);
        }

        @Override
        public void stateMachineError(StateMachine<S, E> stateMachine, Exception exception) {
            StateMachineObjectSupport.this.stateListener.stateMachineError(stateMachine, exception);
        }

        @Override
        public void extendedStateChanged(Object key, Object value) {
            StateMachineObjectSupport.this.stateListener.extendedStateChanged(key, value);
        }

        @Override
        public void stateContext(StateContext<S, E> stateContext) {
            StateMachineObjectSupport.this.stateListener.stateContext(stateContext);
        }
    }
}

