/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.state.PseudoState;
import org.springframework.statemachine.state.PseudoStateKind;
import org.springframework.statemachine.state.State;
import org.springframework.util.ObjectUtils;
import reactor.core.publisher.Mono;

public abstract class StateMachineUtils {
    public static <S, E> boolean isSubstate(State<S, E> left, State<S, E> right) {
        if (left == null) {
            return false;
        }
        Collection<State<S, E>> c = left.getStates();
        c.remove(left);
        return c.contains(right);
    }

    public static <S> boolean containsAtleastOne(Collection<S> left, Collection<S> right) {
        if (left == null || right == null) {
            return false;
        }
        for (S id : left) {
            if (!right.contains(id)) continue;
            return true;
        }
        return false;
    }

    public static <S, E> boolean isNormalPseudoState(State<S, E> state) {
        if (state == null) {
            return false;
        }
        PseudoState<S, E> pseudoState = state.getPseudoState();
        if (pseudoState == null) {
            return false;
        }
        PseudoStateKind kind = pseudoState.getKind();
        return kind != PseudoStateKind.INITIAL && kind != PseudoStateKind.END;
    }

    public static <S, E> boolean isTransientPseudoState(State<S, E> state) {
        if (state == null) {
            return false;
        }
        PseudoState<S, E> pseudoState = state.getPseudoState();
        if (pseudoState == null) {
            return false;
        }
        PseudoStateKind kind = pseudoState.getKind();
        return kind == PseudoStateKind.CHOICE || kind == PseudoStateKind.JUNCTION || kind == PseudoStateKind.ENTRY || kind == PseudoStateKind.EXIT || kind == PseudoStateKind.HISTORY_DEEP || kind == PseudoStateKind.HISTORY_SHALLOW || kind == PseudoStateKind.FORK || kind == PseudoStateKind.JOIN;
    }

    public static <S, E> boolean isPseudoState(State<S, E> state, PseudoStateKind kind) {
        if (state != null) {
            PseudoState<S, E> pseudoState = state.getPseudoState();
            return pseudoState != null && pseudoState.getKind() == kind;
        }
        return false;
    }

    public static <S> Collection<String> toStringCollection(Collection<S> collection) {
        ArrayList<String> c = new ArrayList<String>();
        for (S item : collection) {
            c.add(item.toString());
        }
        return c;
    }

    public static Collection<String> toStringCollection(Object object) {
        ArrayList<String> c = new ArrayList<String>();
        if (ObjectUtils.isArray((Object)object)) {
            for (Object o : ObjectUtils.toObjectArray((Object)object)) {
                c.add(o.toString());
            }
        } else if (object != null) {
            c.add(object.toString());
        }
        return c;
    }

    public static boolean containsAtleastOneEqualString(Collection<String> left, String right) {
        ArrayList<String> r = new ArrayList<String>(1);
        r.add(right);
        return StateMachineUtils.containsAtleastOneEqualString(left, r);
    }

    public static boolean containsAtleastOneEqualString(Collection<String> left, Collection<String> right) {
        if (left == null || right == null) {
            return false;
        }
        for (String id : left) {
            if (!right.contains(id)) continue;
            return true;
        }
        return false;
    }

    public static <S, E> Long getMessageHeaderDoActionTimeout(StateContext<S, E> context) {
        try {
            Number number = (Number)context.getMessageHeaders().get((Object)"STATEMACHINE_DO_ACTION_TIMEOUT", Number.class);
            if (number != null) {
                return number.longValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Function<? super Throwable, Mono<Void>> resumeErrorToContext() {
        return t -> Mono.deferContextual(Mono::just).doOnNext(ctx -> {
            Optional holder = ctx.getOrEmpty((Object)"stateMachineErrors");
            holder.ifPresent(h -> h.setError((Throwable)t));
        }).then();
    }
}

