/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.support;

import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.statemachine.support.StateMachineUtils;
import org.springframework.statemachine.transition.Transition;
import org.springframework.statemachine.transition.TransitionConflictPolicy;

class TransitionComparator<S, E>
implements Comparator<Transition<S, E>> {
    private static final Log log = LogFactory.getLog(TransitionComparator.class);
    private final TransitionConflictPolicy transitionConflictPolicy;

    public TransitionComparator(TransitionConflictPolicy transitionConflictPolicy) {
        this.transitionConflictPolicy = transitionConflictPolicy == null ? TransitionConflictPolicy.CHILD : transitionConflictPolicy;
    }

    @Override
    public int compare(Transition<S, E> left, Transition<S, E> right) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Compare left='" + left + "' right='" + right + "'"));
        }
        if (left == right) {
            return 0;
        }
        boolean substate = StateMachineUtils.isSubstate(left.getSource(), right.getSource());
        if (this.transitionConflictPolicy == TransitionConflictPolicy.CHILD) {
            return substate ? 1 : -1;
        }
        return substate ? -1 : 1;
    }

    public String toString() {
        return "TransitionComparator [transitionConflightPolicy=" + (Object)((Object)this.transitionConflictPolicy) + "]";
    }
}

