/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.transition;

import java.util.Collection;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.action.ActionListener;
import org.springframework.statemachine.action.CompositeActionListener;
import org.springframework.statemachine.security.SecurityRule;
import org.springframework.statemachine.state.State;
import org.springframework.statemachine.transition.Transition;
import org.springframework.statemachine.transition.TransitionKind;
import org.springframework.statemachine.trigger.Trigger;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractTransition<S, E>
implements Transition<S, E> {
    private static final Log log = LogFactory.getLog(AbstractTransition.class);
    protected final State<S, E> target;
    protected final Collection<Function<StateContext<S, E>, Mono<Void>>> actions;
    private final State<S, E> source;
    private final TransitionKind kind;
    private final Function<StateContext<S, E>, Mono<Boolean>> guard;
    private final Trigger<S, E> trigger;
    private final SecurityRule securityRule;
    private final String name;
    private CompositeActionListener<S, E> actionListener;

    public AbstractTransition(State<S, E> source, State<S, E> target, Collection<Function<StateContext<S, E>, Mono<Void>>> actions, E event, TransitionKind kind, Function<StateContext<S, E>, Mono<Boolean>> guard, Trigger<S, E> trigger) {
        this(source, target, actions, event, kind, guard, trigger, null, null);
    }

    public AbstractTransition(State<S, E> source, State<S, E> target, Collection<Function<StateContext<S, E>, Mono<Void>>> actions, E event, TransitionKind kind, Function<StateContext<S, E>, Mono<Boolean>> guard, Trigger<S, E> trigger, SecurityRule securityRule, String name) {
        Assert.notNull((Object)((Object)kind), (String)"Transition type must be set");
        this.source = source;
        this.target = target;
        this.actions = actions;
        this.kind = kind;
        this.guard = guard;
        this.trigger = trigger;
        this.securityRule = securityRule;
        this.name = name == null ? "" : name;
    }

    @Override
    public State<S, E> getSource() {
        return this.source;
    }

    @Override
    public Trigger<S, E> getTrigger() {
        return this.trigger;
    }

    @Override
    public Mono<Boolean> transit(StateContext<S, E> context) {
        if (this.guard != null) {
            return this.guard.apply(context).doOnError(e -> log.warn((Object)"Deny guard due to throw as GUARD should not error", e)).onErrorReturn((Object)false);
        }
        return Mono.just((Object)true);
    }

    @Override
    public Function<StateContext<S, E>, Mono<Boolean>> getGuard() {
        return this.guard;
    }

    @Override
    public TransitionKind getKind() {
        return this.kind;
    }

    @Override
    public SecurityRule getSecurityRule() {
        return this.securityRule;
    }

    @Override
    public State<S, E> getTarget() {
        return this.target;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<Function<StateContext<S, E>, Mono<Void>>> getActions() {
        return this.actions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addActionListener(ActionListener<S, E> listener) {
        AbstractTransition abstractTransition = this;
        synchronized (abstractTransition) {
            if (this.actionListener == null) {
                this.actionListener = new CompositeActionListener();
            }
            this.actionListener.register(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeActionListener(ActionListener<S, E> listener) {
        AbstractTransition abstractTransition = this;
        synchronized (abstractTransition) {
            if (this.actionListener != null) {
                this.actionListener.unregister(listener);
            }
        }
    }

    @Override
    public Mono<Void> executeTransitionActions(StateContext<S, E> context) {
        if (this.getActions() == null) {
            return Mono.empty();
        }
        return Flux.fromIterable(this.getActions()).flatMap(a -> {
            long now = System.currentTimeMillis();
            return ((Mono)a.apply(context)).thenEmpty((Publisher)Mono.fromRunnable(() -> {
                if (this.actionListener != null) {
                    try {
                        this.actionListener.onExecute(context.getStateMachine(), a, System.currentTimeMillis() - now);
                    }
                    catch (Exception e) {
                        log.warn((Object)"Error with actionListener", (Throwable)e);
                    }
                }
            }));
        }).then();
    }

    public String toString() {
        return "AbstractTransition [source=" + this.source + ", target=" + this.target + ", kind=" + (Object)((Object)this.kind) + ", guard=" + this.guard + "]";
    }
}

