/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine;

import org.springframework.messaging.Message;
import org.springframework.statemachine.region.Region;
import reactor.core.publisher.Mono;

public interface StateMachineEventResult<S, E> {
    public Region<S, E> getRegion();

    public Message<E> getMessage();

    public ResultType getResultType();

    public Mono<Void> complete();

    public static <S, E> StateMachineEventResult<S, E> from(Region<S, E> region, Message<E> message, ResultType resultType) {
        return new DefaultStateMachineEventResult<S, E>(region, message, resultType, null);
    }

    public static <S, E> StateMachineEventResult<S, E> from(Region<S, E> region, Message<E> message, ResultType resultType, Mono<Void> complete) {
        return new DefaultStateMachineEventResult<S, E>(region, message, resultType, complete);
    }

    public static class DefaultStateMachineEventResult<S, E>
    implements StateMachineEventResult<S, E> {
        private final Region<S, E> region;
        private final Message<E> message;
        private final ResultType resultType;
        private Mono<Void> complete;

        DefaultStateMachineEventResult(Region<S, E> region, Message<E> message, ResultType resultType, Mono<Void> complete) {
            this.region = region;
            this.message = message;
            this.resultType = resultType;
            this.complete = complete != null ? complete : Mono.empty();
        }

        @Override
        public Region<S, E> getRegion() {
            return this.region;
        }

        @Override
        public Message<E> getMessage() {
            return this.message;
        }

        @Override
        public ResultType getResultType() {
            return this.resultType;
        }

        @Override
        public Mono<Void> complete() {
            return this.complete;
        }

        public String toString() {
            return "DefaultStateMachineEventResult [region=" + this.region + ", message=" + this.message + ", resultType=" + this.resultType + "]";
        }
    }

    public static enum ResultType {
        ACCEPTED,
        DENIED,
        DEFERRED;

    }
}

