/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.action;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.action.Action;
import org.springframework.statemachine.support.DefaultStateContext;
import reactor.core.publisher.Mono;

public final class Actions {
    private Actions() {
    }

    public static <S, E> Action<S, E> emptyAction() {
        return new Action<S, E>(){

            @Override
            public void execute(StateContext<S, E> context) {
            }
        };
    }

    public static <S, E> Action<S, E> errorCallingAction(final Action<S, E> action, final Action<S, E> errorAction) {
        return new Action<S, E>(){

            @Override
            public void execute(StateContext<S, E> context) {
                try {
                    action.execute(context);
                }
                catch (Exception exception) {
                    try {
                        errorAction.execute(new DefaultStateContext(context.getStage(), context.getMessage(), context.getMessageHeaders(), context.getExtendedState(), context.getTransition(), context.getStateMachine(), context.getSource(), context.getTarget(), context.getSources(), context.getTargets(), exception));
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    throw exception;
                }
            }
        };
    }

    public static <S, E> Function<StateContext<S, E>, Mono<Void>> from(Action<S, E> action) {
        if (action != null) {
            return context -> Mono.fromRunnable(() -> action.execute((StateContext)context));
        }
        return null;
    }

    public static <S, E> Collection<Function<StateContext<S, E>, Mono<Void>>> from(Collection<Action<S, E>> actions) {
        if (actions != null) {
            return actions.stream().map(action -> Actions.from(action)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

