/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.config;

import java.util.UUID;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.config.ObjectStateMachineFactory;
import org.springframework.statemachine.config.StateMachineConfig;
import org.springframework.statemachine.config.builders.StateMachineConfigBuilder;
import org.springframework.statemachine.config.model.ConfigurationData;
import org.springframework.statemachine.config.model.DefaultStateMachineModel;
import org.springframework.statemachine.config.model.StatesData;
import org.springframework.statemachine.config.model.TransitionsData;

public interface StateMachineFactory<S, E> {
    public StateMachine<S, E> getStateMachine();

    public StateMachine<S, E> getStateMachine(String var1);

    public StateMachine<S, E> getStateMachine(UUID var1);

    public static <S, E> ObjectStateMachineFactory<S, E> create(StateMachineConfigBuilder<S, E> builder) {
        StateMachineConfig stateMachineConfig = (StateMachineConfig)builder.getOrBuild();
        TransitionsData stateMachineTransitions = stateMachineConfig.getTransitions();
        StatesData stateMachineStates = stateMachineConfig.getStates();
        ConfigurationData stateMachineConfigurationConfig = stateMachineConfig.getStateMachineConfigurationConfig();
        ObjectStateMachineFactory stateMachineFactory = null;
        stateMachineFactory = stateMachineConfig.getModel() != null && stateMachineConfig.getModel().getFactory() != null ? new ObjectStateMachineFactory(new DefaultStateMachineModel(stateMachineConfigurationConfig, null, null), stateMachineConfig.getModel().getFactory()) : new ObjectStateMachineFactory(new DefaultStateMachineModel(stateMachineConfigurationConfig, stateMachineStates, stateMachineTransitions), null);
        return stateMachineFactory;
    }
}

