/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.config.configurers;

import java.util.function.Function;
import org.springframework.expression.spel.SpelCompilerMode;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.action.Action;
import org.springframework.statemachine.config.builders.StateMachineTransitionBuilder;
import org.springframework.statemachine.config.configurers.AbstractTransitionConfigurer;
import org.springframework.statemachine.config.configurers.ExternalTransitionConfigurer;
import org.springframework.statemachine.guard.Guard;
import org.springframework.statemachine.guard.SpelExpressionGuard;
import org.springframework.statemachine.security.SecurityRule;
import org.springframework.statemachine.transition.TransitionKind;
import reactor.core.publisher.Mono;

public class DefaultExternalTransitionConfigurer<S, E>
extends AbstractTransitionConfigurer<S, E>
implements ExternalTransitionConfigurer<S, E> {
    @Override
    public void configure(StateMachineTransitionBuilder<S, E> builder) throws Exception {
        builder.addTransition(this.getSource(), this.getTarget(), this.getState(), this.getEvent(), this.getPeriod(), this.getCount(), this.getActions(), this.getGuard(), TransitionKind.EXTERNAL, this.getSecurityRule(), this.getName());
    }

    @Override
    public ExternalTransitionConfigurer<S, E> source(S source) {
        this.setSource(source);
        return this;
    }

    @Override
    public ExternalTransitionConfigurer<S, E> target(S target) {
        this.setTarget(target);
        return this;
    }

    @Override
    public ExternalTransitionConfigurer<S, E> state(S state) {
        this.setState(state);
        return this;
    }

    @Override
    public ExternalTransitionConfigurer<S, E> event(E event) {
        this.setEvent(event);
        return this;
    }

    @Override
    public ExternalTransitionConfigurer<S, E> timer(long period) {
        this.setPeriod(period);
        return this;
    }

    @Override
    public ExternalTransitionConfigurer<S, E> timerOnce(long period) {
        this.setPeriod(period);
        this.setCount(1);
        return this;
    }

    @Override
    public ExternalTransitionConfigurer<S, E> action(Action<S, E> action) {
        return this.action((Action)action, (Action)null);
    }

    @Override
    public ExternalTransitionConfigurer<S, E> action(Action<S, E> action, Action<S, E> error) {
        this.addAction(action, error);
        return this;
    }

    @Override
    public ExternalTransitionConfigurer<S, E> actionFunction(Function<StateContext<S, E>, Mono<Void>> action) {
        this.addActionFunction(action);
        return this;
    }

    @Override
    public ExternalTransitionConfigurer<S, E> guard(Guard<S, E> guard) {
        this.setGuard(guard);
        return this;
    }

    @Override
    public ExternalTransitionConfigurer<S, E> guardExpression(String expression) {
        SpelExpressionParser parser = new SpelExpressionParser(new SpelParserConfiguration(SpelCompilerMode.MIXED, null));
        this.setGuard(new SpelExpressionGuard(parser.parseExpression(expression)));
        return this;
    }

    @Override
    public ExternalTransitionConfigurer<S, E> secured(String attributes, SecurityRule.ComparisonType match) {
        this.setSecurityRule(attributes, match);
        return this;
    }

    @Override
    public ExternalTransitionConfigurer<S, E> secured(String expression) {
        this.setSecurityRule(expression);
        return this;
    }

    @Override
    public ExternalTransitionConfigurer<S, E> name(String name) {
        this.setName(name);
        return this;
    }
}

