/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.security;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.SpelCompilerMode;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.messaging.Message;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.access.vote.AbstractAccessDecisionManager;
import org.springframework.security.access.vote.AffirmativeBased;
import org.springframework.security.access.vote.ConsensusBased;
import org.springframework.security.access.vote.RoleVoter;
import org.springframework.security.access.vote.UnanimousBased;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.security.EventExpressionConfigAttribute;
import org.springframework.statemachine.security.EventExpressionVoter;
import org.springframework.statemachine.security.EventVoter;
import org.springframework.statemachine.security.SecurityRule;
import org.springframework.statemachine.security.TransitionExpressionConfigAttribute;
import org.springframework.statemachine.security.TransitionExpressionVoter;
import org.springframework.statemachine.security.TransitionVoter;
import org.springframework.statemachine.support.StateMachineInterceptorAdapter;
import org.springframework.statemachine.transition.Transition;
import org.springframework.util.StringUtils;

public class StateMachineSecurityInterceptor<S, E>
extends StateMachineInterceptorAdapter<S, E> {
    private AccessDecisionManager transitionAccessDecisionManager;
    private AccessDecisionManager eventAccessDecisionManager;
    private final ExpressionParser expressionParser = new SpelExpressionParser(new SpelParserConfiguration(SpelCompilerMode.OFF, null));
    private SecurityRule eventSecurityRule;

    public StateMachineSecurityInterceptor() {
        this(null, null);
    }

    public StateMachineSecurityInterceptor(AccessDecisionManager transitionAccessDecisionManager, AccessDecisionManager eventAccessDecisionManager) {
        this(transitionAccessDecisionManager, eventAccessDecisionManager, null);
    }

    public StateMachineSecurityInterceptor(AccessDecisionManager transitionAccessDecisionManager, AccessDecisionManager eventAccessDecisionManager, SecurityRule eventSecurityRule) {
        this.transitionAccessDecisionManager = transitionAccessDecisionManager;
        this.eventAccessDecisionManager = eventAccessDecisionManager;
        this.eventSecurityRule = eventSecurityRule;
    }

    @Override
    public Message<E> preEvent(Message<E> message, StateMachine<S, E> stateMachine) {
        if (this.eventSecurityRule != null) {
            this.decide(this.eventSecurityRule, message);
        }
        return super.preEvent(message, stateMachine);
    }

    @Override
    public StateContext<S, E> preTransition(StateContext<S, E> stateContext) {
        Transition<S, E> transition = stateContext.getTransition();
        SecurityRule rule = transition.getSecurityRule();
        if (rule != null) {
            this.decide(rule, transition);
        }
        return super.preTransition(stateContext);
    }

    public void setEventAccessDecisionManager(AccessDecisionManager eventAccessDecisionManager) {
        this.eventAccessDecisionManager = eventAccessDecisionManager;
    }

    public void setTransitionAccessDecisionManager(AccessDecisionManager transitionAccessDecisionManager) {
        this.transitionAccessDecisionManager = transitionAccessDecisionManager;
    }

    public void setEventSecurityRule(SecurityRule eventSecurityRule) {
        this.eventSecurityRule = eventSecurityRule;
    }

    private void decide(SecurityRule rule, Message<E> object) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Collection<ConfigAttribute> configAttributes = this.getEentConfigAttributes(rule);
        if (this.eventAccessDecisionManager != null) {
            this.decide(this.eventAccessDecisionManager, authentication, object, configAttributes);
        } else {
            this.decide((AccessDecisionManager)this.createDefaultEventManager(rule), authentication, object, configAttributes);
        }
    }

    private void decide(SecurityRule rule, Transition<S, E> object) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Collection<ConfigAttribute> configAttributes = this.getTransitionConfigAttributes(rule);
        if (this.transitionAccessDecisionManager != null) {
            this.decide(this.transitionAccessDecisionManager, authentication, object, configAttributes);
        } else {
            this.decide((AccessDecisionManager)this.createDefaultTransitionManager(rule), authentication, object, configAttributes);
        }
    }

    private Collection<ConfigAttribute> getTransitionConfigAttributes(SecurityRule rule) {
        ArrayList<ConfigAttribute> configAttributes = new ArrayList<ConfigAttribute>();
        if (rule.getAttributes() != null) {
            for (String attribute : rule.getAttributes()) {
                configAttributes.add((ConfigAttribute)new SecurityConfig(attribute));
            }
        }
        if (StringUtils.hasText((String)rule.getExpression())) {
            configAttributes.add(new TransitionExpressionConfigAttribute(this.expressionParser.parseExpression(rule.getExpression())));
        }
        return configAttributes;
    }

    private Collection<ConfigAttribute> getEentConfigAttributes(SecurityRule rule) {
        ArrayList<ConfigAttribute> configAttributes = new ArrayList<ConfigAttribute>();
        if (rule.getAttributes() != null) {
            for (String attribute : rule.getAttributes()) {
                configAttributes.add((ConfigAttribute)new SecurityConfig(attribute));
            }
        }
        if (StringUtils.hasText((String)rule.getExpression())) {
            configAttributes.add(new EventExpressionConfigAttribute(this.expressionParser.parseExpression(rule.getExpression())));
        }
        return configAttributes;
    }

    private void decide(AccessDecisionManager manager, Authentication authentication, Transition<S, E> object, Collection<ConfigAttribute> configAttributes) {
        if (manager.supports(object.getClass())) {
            manager.decide(authentication, object, configAttributes);
        }
    }

    private void decide(AccessDecisionManager manager, Authentication authentication, Message<E> object, Collection<ConfigAttribute> configAttributes) {
        if (manager.supports(object.getClass())) {
            manager.decide(authentication, object, configAttributes);
        }
    }

    private AbstractAccessDecisionManager createDefaultTransitionManager(SecurityRule rule) {
        ArrayList<Object> voters = new ArrayList<Object>();
        voters.add(new TransitionExpressionVoter());
        voters.add(new TransitionVoter());
        voters.add(new RoleVoter());
        if (rule.getComparisonType() == SecurityRule.ComparisonType.ANY) {
            return new AffirmativeBased(voters);
        }
        if (rule.getComparisonType() == SecurityRule.ComparisonType.ALL) {
            return new UnanimousBased(voters);
        }
        if (rule.getComparisonType() == SecurityRule.ComparisonType.MAJORITY) {
            return new ConsensusBased(voters);
        }
        throw new IllegalStateException("Unknown SecurityRule match type: " + rule.getComparisonType());
    }

    private AbstractAccessDecisionManager createDefaultEventManager(SecurityRule rule) {
        ArrayList<Object> voters = new ArrayList<Object>();
        voters.add(new EventExpressionVoter());
        voters.add(new EventVoter());
        voters.add(new RoleVoter());
        if (rule.getComparisonType() == SecurityRule.ComparisonType.ANY) {
            return new AffirmativeBased(voters);
        }
        if (rule.getComparisonType() == SecurityRule.ComparisonType.ALL) {
            return new UnanimousBased(voters);
        }
        if (rule.getComparisonType() == SecurityRule.ComparisonType.MAJORITY) {
            return new ConsensusBased(voters);
        }
        throw new IllegalStateException("Unknown SecurityRule match type: " + rule.getComparisonType());
    }

    public String toString() {
        return "StateMachineSecurityInterceptor [transitionAccessDecisionManager=" + this.transitionAccessDecisionManager + ", eventAccessDecisionManager=" + this.eventAccessDecisionManager + ", eventSecurityRule=" + this.eventSecurityRule + "]";
    }
}

