/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.state.AbstractPseudoState;
import org.springframework.statemachine.state.DefaultPseudoStateContext;
import org.springframework.statemachine.state.PseudoStateContext;
import org.springframework.statemachine.state.PseudoStateKind;
import org.springframework.statemachine.state.State;
import org.springframework.statemachine.state.StateHolder;
import org.springframework.statemachine.state.StateListenerAdapter;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class JoinPseudoState<S, E>
extends AbstractPseudoState<S, E> {
    private static final Log log = LogFactory.getLog(JoinPseudoState.class);
    private final List<List<State<S, E>>> joins;
    private final JoinTracker tracker;
    private final List<JoinStateData<S, E>> joinTargets;

    public JoinPseudoState(List<List<State<S, E>>> joins, List<JoinStateData<S, E>> joinTargets) {
        super(PseudoStateKind.JOIN);
        this.joins = joins;
        this.joinTargets = joinTargets;
        this.tracker = new JoinTracker();
    }

    @Override
    public Mono<State<S, E>> entry(StateContext<S, E> context) {
        return Mono.defer(() -> {
            if (!this.tracker.isNotified()) {
                return Mono.empty();
            }
            return Flux.fromIterable(this.joinTargets).filterWhen(jst -> this.evaluateInternal(jst.guard, context)).next().map(jst -> jst.getState());
        });
    }

    @Override
    public Mono<Void> exit(StateContext<S, E> context) {
        return Mono.fromRunnable(() -> this.tracker.reset());
    }

    public List<List<State<S, E>>> getJoins() {
        return this.joins;
    }

    public void reset(Collection<S> ids) {
        this.tracker.reset(ids);
    }

    private Mono<Boolean> evaluateInternal(Function<StateContext<S, E>, Mono<Boolean>> guard, StateContext<S, E> context) {
        if (guard == null) {
            return Mono.just((Object)true);
        }
        try {
            return guard.apply(context);
        }
        catch (Exception e) {
            log.warn((Object)"Deny guard due to throw as GUARD should not error");
            return Mono.just((Object)false);
        }
    }

    private class JoinTracker {
        private final List<List<State<S, E>>> track;
        private volatile boolean notified = false;

        public JoinTracker() {
            this.track = new ArrayList(JoinPseudoState.this.joins.size());
            for (List list : JoinPseudoState.this.joins) {
                this.track.add(new ArrayList(list));
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    State tt;
                    final State t = tt = iterator.next();
                    t.addStateListener(new StateListenerAdapter<S, E>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onComplete(StateContext<S, E> context) {
                            List list = JoinTracker.this.track;
                            synchronized (list) {
                                Iterator iterator = JoinTracker.this.track.iterator();
                                while (iterator.hasNext()) {
                                    List next = iterator.next();
                                    if (!next.contains(t)) continue;
                                    iterator.remove();
                                }
                            }
                            if (!JoinTracker.this.notified && JoinTracker.this.track.isEmpty()) {
                                log.debug((Object)"Join complete");
                                JoinTracker.this.notified = true;
                                JoinPseudoState.this.notifyContext(new DefaultPseudoStateContext(JoinPseudoState.this, PseudoStateContext.PseudoAction.JOIN_COMPLETED));
                            }
                        }
                    });
                }
            }
        }

        void reset() {
            this.track.clear();
            for (List list : JoinPseudoState.this.joins) {
                this.track.add(new ArrayList(list));
            }
            this.notified = false;
        }

        void reset(Collection<S> ids) {
            this.reset();
            Iterator trackIter = this.track.iterator();
            while (trackIter.hasNext()) {
                List list = trackIter.next();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    State next = iterator.next();
                    if (!ids.contains(next.getId())) continue;
                    iterator.remove();
                    trackIter.remove();
                }
            }
        }

        public boolean isNotified() {
            return this.notified;
        }
    }

    public static class JoinStateData<S, E> {
        private final StateHolder<S, E> state;
        private final Function<StateContext<S, E>, Mono<Boolean>> guard;

        public JoinStateData(StateHolder<S, E> state, Function<StateContext<S, E>, Mono<Boolean>> guard) {
            Assert.notNull(state, (String)"Holder must be set");
            this.state = state;
            this.guard = guard;
        }

        public StateHolder<S, E> getStateHolder() {
            return this.state;
        }

        public State<S, E> getState() {
            return this.state.getState();
        }

        public Function<StateContext<S, E>, Mono<Boolean>> getGuard() {
            return this.guard;
        }
    }
}

