/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.support;

import java.util.Collection;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.statemachine.ExtendedState;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.state.State;
import org.springframework.statemachine.transition.Transition;

public class DefaultStateContext<S, E>
implements StateContext<S, E> {
    private final StateContext.Stage stage;
    private final Message<E> message;
    private final MessageHeaders messageHeaders;
    private final ExtendedState extendedState;
    private final Transition<S, E> transition;
    private final StateMachine<S, E> stateMachine;
    private final State<S, E> source;
    private final State<S, E> target;
    private final Collection<State<S, E>> sources;
    private final Collection<State<S, E>> targets;
    private final Exception exception;

    public DefaultStateContext(StateContext.Stage stage, Message<E> message, MessageHeaders messageHeaders, ExtendedState extendedState, Transition<S, E> transition, StateMachine<S, E> stateMachine, State<S, E> source, State<S, E> target, Exception exception) {
        this.stage = stage;
        this.message = message;
        this.messageHeaders = messageHeaders;
        this.extendedState = extendedState;
        this.transition = transition;
        this.stateMachine = stateMachine;
        this.source = source;
        this.target = target;
        this.exception = exception;
        this.sources = null;
        this.targets = null;
    }

    public DefaultStateContext(StateContext.Stage stage, Message<E> message, MessageHeaders messageHeaders, ExtendedState extendedState, Transition<S, E> transition, StateMachine<S, E> stateMachine, State<S, E> source, State<S, E> target, Collection<State<S, E>> sources, Collection<State<S, E>> targets, Exception exception) {
        this.stage = stage;
        this.message = message;
        this.messageHeaders = messageHeaders;
        this.extendedState = extendedState;
        this.transition = transition;
        this.stateMachine = stateMachine;
        this.source = source;
        this.target = target;
        this.sources = sources;
        this.targets = targets;
        this.exception = exception;
    }

    @Override
    public StateContext.Stage getStage() {
        return this.stage;
    }

    @Override
    public E getEvent() {
        return (E)(this.message != null ? this.message.getPayload() : null);
    }

    @Override
    public Message<E> getMessage() {
        return this.message;
    }

    @Override
    public MessageHeaders getMessageHeaders() {
        return this.messageHeaders;
    }

    @Override
    public Object getMessageHeader(Object header) {
        if (header instanceof String) {
            return this.messageHeaders.get((Object)((String)header));
        }
        if (header instanceof Enum) {
            return this.messageHeaders.get((Object)((Enum)header).toString());
        }
        return null;
    }

    @Override
    public ExtendedState getExtendedState() {
        return this.extendedState;
    }

    @Override
    public Transition<S, E> getTransition() {
        return this.transition;
    }

    @Override
    public StateMachine<S, E> getStateMachine() {
        return this.stateMachine;
    }

    @Override
    public State<S, E> getSource() {
        return this.source != null ? this.source : (this.transition != null ? this.transition.getSource() : null);
    }

    @Override
    public Collection<State<S, E>> getSources() {
        return this.sources;
    }

    @Override
    public State<S, E> getTarget() {
        return this.target != null ? this.target : (this.transition != null ? this.transition.getTarget() : null);
    }

    @Override
    public Collection<State<S, E>> getTargets() {
        return this.targets;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    public String toString() {
        return "DefaultStateContext [stage=" + this.stage + ", message=" + this.message + ", messageHeaders=" + this.messageHeaders + ", extendedState=" + this.extendedState + ", transition=" + this.transition + ", stateMachine=" + this.stateMachine + ", source=" + this.source + ", target=" + this.target + ", sources=" + this.sources + ", targets=" + this.targets + ", exception=" + this.exception + "]";
    }
}

