/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.trigger;

import java.time.Duration;
import org.springframework.statemachine.support.LifecycleObjectSupport;
import org.springframework.statemachine.trigger.CompositeTriggerListener;
import org.springframework.statemachine.trigger.Trigger;
import org.springframework.statemachine.trigger.TriggerContext;
import org.springframework.statemachine.trigger.TriggerListener;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class TimerTrigger<S, E>
extends LifecycleObjectSupport
implements Trigger<S, E> {
    private final CompositeTriggerListener triggerListener = new CompositeTriggerListener();
    private final long period;
    private final int count;
    private Disposable disposable;

    public TimerTrigger(long period) {
        this(period, 0);
    }

    public TimerTrigger(long period, int count) {
        this.period = period;
        this.count = count;
    }

    public long getPeriod() {
        return this.period;
    }

    public int getCount() {
        return this.count;
    }

    @Override
    public Mono<Boolean> evaluate(TriggerContext<S, E> context) {
        return Mono.just((Object)false);
    }

    @Override
    public void addTriggerListener(TriggerListener listener) {
        this.triggerListener.register(listener);
    }

    @Override
    public E getEvent() {
        return null;
    }

    @Override
    protected Mono<Void> doPreStartReactively() {
        return Mono.defer(() -> {
            if (this.count > 0) {
                return Mono.empty();
            }
            return Mono.fromRunnable(() -> this.schedule());
        });
    }

    @Override
    protected Mono<Void> doPreStopReactively() {
        return Mono.defer(() -> {
            this.cancel();
            return Mono.empty();
        });
    }

    @Override
    public void arm() {
        if (this.disposable != null) {
            return;
        }
        this.schedule();
    }

    @Override
    public void disarm() {
        if (this.count > 0) {
            this.cancel();
        }
    }

    private void schedule() {
        long initialDelay = this.count > 0 ? this.period : 0L;
        Flux interval = Flux.interval((Duration)Duration.ofMillis(initialDelay), (Duration)Duration.ofMillis(this.period)).doOnNext(c -> this.notifyTriggered());
        if (this.count > 0) {
            interval = interval.take((long)this.count);
        }
        this.disposable = interval.subscribe();
    }

    private void notifyTriggered() {
        this.triggerListener.triggered();
    }

    private void cancel() {
        if (this.disposable != null) {
            this.disposable.dispose();
        }
        this.disposable = null;
    }
}

