/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.authentication;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.vault.VaultException;
import org.springframework.vault.authentication.AppRoleAuthenticationOptions;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.LoginTokenUtil;
import org.springframework.vault.client.VaultResponses;
import org.springframework.vault.support.VaultResponse;
import org.springframework.vault.support.VaultToken;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestOperations;

public class AppRoleAuthentication
implements ClientAuthentication {
    private static final Log logger = LogFactory.getLog(AppRoleAuthentication.class);
    private final AppRoleAuthenticationOptions options;
    private final RestOperations restOperations;

    public AppRoleAuthentication(AppRoleAuthenticationOptions options, RestOperations restOperations) {
        Assert.notNull((Object)options, (String)"AppRoleAuthenticationOptions must not be null");
        Assert.notNull((Object)restOperations, (String)"RestOperations must not be null");
        this.options = options;
        this.restOperations = restOperations;
    }

    @Override
    public VaultToken login() {
        return this.createTokenUsingAppRole();
    }

    private VaultToken createTokenUsingAppRole() {
        Map<String, String> login = this.getAppRoleLogin(this.options.getRoleId(), this.options.getSecretId());
        try {
            VaultResponse response = (VaultResponse)this.restOperations.postForObject("/auth/{mount}/login", login, VaultResponse.class, new Object[]{this.options.getPath()});
            logger.debug((Object)"Login successful using AppRole authentication");
            return LoginTokenUtil.from(response.getAuth());
        }
        catch (HttpStatusCodeException e) {
            throw new VaultException(String.format("Cannot login using AppRole: %s", VaultResponses.getError(e.getResponseBodyAsString())));
        }
    }

    private Map<String, String> getAppRoleLogin(String roleId, String secretId) {
        HashMap<String, String> login = new HashMap<String, String>();
        login.put("role_id", roleId);
        if (secretId != null) {
            login.put("secret_id", secretId);
        }
        return login;
    }
}

