/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.authentication;

import org.springframework.util.Assert;

public class AppRoleAuthenticationOptions {
    public static final String DEFAULT_APPROLE_AUTHENTICATION_PATH = "approle";
    private final String path;
    private final String roleId;
    private final String secretId;

    private AppRoleAuthenticationOptions(String path, String roleId, String secretId) {
        this.path = path;
        this.roleId = roleId;
        this.secretId = secretId;
    }

    public static AppRoleAuthenticationOptionsBuilder builder() {
        return new AppRoleAuthenticationOptionsBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getRoleId() {
        return this.roleId;
    }

    public String getSecretId() {
        return this.secretId;
    }

    public static class AppRoleAuthenticationOptionsBuilder {
        private String path = "approle";
        private String roleId;
        private String secretId;

        AppRoleAuthenticationOptionsBuilder() {
        }

        public AppRoleAuthenticationOptionsBuilder path(String path) {
            Assert.hasText((String)path, (String)"Path must not be empty");
            this.path = path;
            return this;
        }

        public AppRoleAuthenticationOptionsBuilder roleId(String roleId) {
            Assert.hasText((String)roleId, (String)"RoleId must not be empty");
            this.roleId = roleId;
            return this;
        }

        public AppRoleAuthenticationOptionsBuilder secretId(String secretId) {
            Assert.hasText((String)secretId, (String)"SecretId must not be empty");
            this.secretId = secretId;
            return this;
        }

        public AppRoleAuthenticationOptions build() {
            Assert.hasText((String)this.path, (String)"Path must not be empty");
            Assert.notNull((Object)this.roleId, (String)"RoleId must not be null");
            return new AppRoleAuthenticationOptions(this.path, this.roleId, this.secretId);
        }
    }
}

