/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.authentication;

import java.net.URI;
import org.springframework.util.Assert;

public class AwsEc2AuthenticationOptions {
    public static final URI DEFAULT_PKCS7_IDENTITY_DOCUMENT_URI = URI.create("http://169.254.169.254/latest/dynamic/instance-identity/pkcs7");
    public static final String DEFAULT_AWS_AUTHENTICATION_PATH = "aws-ec2";
    public static final AwsEc2AuthenticationOptions DEFAULT = new AwsEc2AuthenticationOptions();
    private final String path;
    private final URI identityDocumentUri;
    private final String role;

    private AwsEc2AuthenticationOptions() {
        this(DEFAULT_AWS_AUTHENTICATION_PATH, DEFAULT_PKCS7_IDENTITY_DOCUMENT_URI, "");
    }

    private AwsEc2AuthenticationOptions(String path, URI identityDocumentUri, String role) {
        this.path = path;
        this.identityDocumentUri = identityDocumentUri;
        this.role = role;
    }

    public static AwsEc2AuthenticationOptionsBuilder builder() {
        return new AwsEc2AuthenticationOptionsBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public URI getIdentityDocumentUri() {
        return this.identityDocumentUri;
    }

    public String getRole() {
        return this.role;
    }

    public static class AwsEc2AuthenticationOptionsBuilder {
        private String path = "aws-ec2";
        private URI identityDocumentUri = DEFAULT_PKCS7_IDENTITY_DOCUMENT_URI;
        private String role;

        AwsEc2AuthenticationOptionsBuilder() {
        }

        public AwsEc2AuthenticationOptionsBuilder path(String path) {
            Assert.hasText((String)path, (String)"Path must not be empty");
            this.path = path;
            return this;
        }

        public AwsEc2AuthenticationOptionsBuilder identityDocumentUri(URI identityDocumentUri) {
            this.identityDocumentUri = identityDocumentUri;
            return this;
        }

        public AwsEc2AuthenticationOptionsBuilder role(String role) {
            this.role = role;
            return this;
        }

        public AwsEc2AuthenticationOptions build() {
            Assert.notNull((Object)this.identityDocumentUri, (String)"IdentityDocumentUri must not be null");
            return new AwsEc2AuthenticationOptions(this.path, this.identityDocumentUri, this.role);
        }
    }
}

