/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.authentication;

import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.vault.VaultException;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.LoginTokenUtil;
import org.springframework.vault.client.VaultResponses;
import org.springframework.vault.support.VaultResponse;
import org.springframework.vault.support.VaultToken;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestOperations;

public class ClientCertificateAuthentication
implements ClientAuthentication {
    private static final Log logger = LogFactory.getLog(ClientCertificateAuthentication.class);
    private final RestOperations restOperations;

    public ClientCertificateAuthentication(RestOperations restOperations) {
        Assert.notNull((Object)restOperations, (String)"RestOperations must not be null");
        this.restOperations = restOperations;
    }

    @Override
    public VaultToken login() {
        return this.createTokenUsingTlsCertAuthentication("cert");
    }

    private VaultToken createTokenUsingTlsCertAuthentication(String path) {
        try {
            VaultResponse response = (VaultResponse)this.restOperations.postForObject("/auth/{mount}/login", Collections.emptyMap(), VaultResponse.class, new Object[]{path});
            logger.debug((Object)"Login successful using TLS certificates");
            return LoginTokenUtil.from(response.getAuth());
        }
        catch (HttpStatusCodeException e) {
            throw new VaultException(String.format("Cannot login using TLS certificates: %s", VaultResponses.getError(e.getResponseBodyAsString())));
        }
    }
}

