/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.authentication;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.vault.VaultException;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.CubbyholeAuthenticationOptions;
import org.springframework.vault.authentication.LoginToken;
import org.springframework.vault.authentication.LoginTokenUtil;
import org.springframework.vault.client.VaultHttpHeaders;
import org.springframework.vault.client.VaultResponses;
import org.springframework.vault.support.VaultResponse;
import org.springframework.vault.support.VaultToken;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestOperations;

public class CubbyholeAuthentication
implements ClientAuthentication {
    private static final Log logger = LogFactory.getLog(CubbyholeAuthentication.class);
    private final CubbyholeAuthenticationOptions options;
    private final RestOperations restOperations;

    public CubbyholeAuthentication(CubbyholeAuthenticationOptions options, RestOperations restOperations) {
        Assert.notNull((Object)options, (String)"CubbyholeAuthenticationOptions must not be null");
        Assert.notNull((Object)restOperations, (String)"RestOperations must not be null");
        this.options = options;
        this.restOperations = restOperations;
    }

    @Override
    public VaultToken login() throws VaultException {
        Map<String, Object> data = this.lookupToken();
        VaultToken tokenToUse = this.getToken(data);
        if (this.shouldEnhanceTokenWithSelfLookup(tokenToUse)) {
            tokenToUse = this.augmentWithSelfLookup(tokenToUse);
        }
        logger.debug((Object)"Login successful using Cubbyhole authentication");
        return tokenToUse;
    }

    private Map<String, Object> lookupToken() {
        try {
            ResponseEntity entity = this.restOperations.exchange(this.options.getPath(), HttpMethod.GET, new HttpEntity((MultiValueMap)VaultHttpHeaders.from(this.options.getInitialToken())), VaultResponse.class, new Object[0]);
            return (Map)((VaultResponse)entity.getBody()).getData();
        }
        catch (HttpStatusCodeException e) {
            throw new VaultException(String.format("Cannot retrieve Token from Cubbyhole: %s %s", e.getStatusCode(), VaultResponses.getError(e.getResponseBodyAsString())));
        }
    }

    private boolean shouldEnhanceTokenWithSelfLookup(VaultToken token) {
        LoginToken loginToken;
        if (!this.options.isSelfLookup()) {
            return false;
        }
        return !(token instanceof LoginToken) || (loginToken = (LoginToken)token).getLeaseDuration() != 0L;
    }

    private VaultToken augmentWithSelfLookup(VaultToken token) {
        Map<String, Object> data = this.lookupSelf(token);
        Boolean renewable = (Boolean)data.get("renewable");
        Number ttl = (Number)data.get("ttl");
        if (renewable != null && renewable.booleanValue()) {
            return LoginToken.renewable(token.getToken(), ttl == null ? 0L : ttl.longValue());
        }
        return LoginToken.of(token.getToken(), ttl == null ? 0L : ttl.longValue());
    }

    private Map<String, Object> lookupSelf(VaultToken token) {
        try {
            ResponseEntity entity = this.restOperations.exchange("/auth/token/lookup-self", HttpMethod.GET, new HttpEntity((MultiValueMap)VaultHttpHeaders.from(token)), VaultResponse.class, new Object[0]);
            return (Map)((VaultResponse)entity.getBody()).getData();
        }
        catch (HttpStatusCodeException e) {
            throw new VaultException(String.format("Cannot self-lookup Token from Cubbyhole: %s %s", e.getStatusCode(), VaultResponses.getError(e.getResponseBodyAsString())));
        }
    }

    private VaultToken getToken(Map<String, Object> data) {
        if (this.options.isWrappedToken()) {
            VaultResponse response = VaultResponses.unwrap((String)data.get("response"), VaultResponse.class);
            return LoginTokenUtil.from(response.getAuth());
        }
        if (data == null || data.isEmpty()) {
            throw new VaultException(String.format("Cannot retrieve Token from Cubbyhole: Response at %s does not contain a token", this.options.getPath()));
        }
        if (data.size() == 1) {
            String token = (String)data.get(data.keySet().iterator().next());
            return VaultToken.of(token);
        }
        throw new VaultException(String.format("Cannot retrieve Token from Cubbyhole: Response at %s does not contain an unique token", this.options.getPath()));
    }
}

