/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.authentication;

import org.springframework.util.Assert;
import org.springframework.vault.support.VaultToken;

public class LoginToken
extends VaultToken {
    private final boolean renewable;
    private final long leaseDuration;

    private LoginToken(String token, long leaseDuration, boolean renewable) {
        super(token);
        this.leaseDuration = leaseDuration;
        this.renewable = renewable;
    }

    public static LoginToken of(String token) {
        return LoginToken.of(token, 0L);
    }

    public static LoginToken of(String token, long leaseDuration) {
        Assert.hasText((String)token, (String)"Token must not be empty");
        return new LoginToken(token, leaseDuration, false);
    }

    public static LoginToken renewable(String token, long leaseDuration) {
        Assert.hasText((String)token, (String)"Token must not be empty");
        return new LoginToken(token, leaseDuration, true);
    }

    public long getLeaseDuration() {
        return this.leaseDuration;
    }

    public boolean isRenewable() {
        return this.renewable;
    }

    @Override
    public String toString() {
        return "LoginToken(renewable=" + this.isRenewable() + ", leaseDuration=" + this.getLeaseDuration() + ")";
    }
}

