/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.client;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.vault.client.VaultEndpoint;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.DefaultUriTemplateHandler;
import org.springframework.web.util.UriTemplateHandler;

public class VaultClients {
    public static RestTemplate createRestTemplate(VaultEndpoint endpoint, ClientHttpRequestFactory requestFactory) {
        RestTemplate restTemplate = VaultClients.createRestTemplate();
        restTemplate.setRequestFactory(requestFactory);
        restTemplate.setUriTemplateHandler((UriTemplateHandler)VaultClients.createUriTemplateHandler(endpoint));
        return restTemplate;
    }

    public static RestTemplate createRestTemplate() {
        ArrayList<Object> messageConverters = new ArrayList<Object>(3);
        messageConverters.add(new ByteArrayHttpMessageConverter());
        messageConverters.add(new StringHttpMessageConverter());
        messageConverters.add(new MappingJackson2HttpMessageConverter());
        RestTemplate restTemplate = new RestTemplate(messageConverters);
        restTemplate.getInterceptors().add(new ClientHttpRequestInterceptor(){

            public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
                return execution.execute(request, body);
            }
        });
        return restTemplate;
    }

    private static DefaultUriTemplateHandler createUriTemplateHandler(VaultEndpoint endpoint) {
        String baseUrl = String.format("%s://%s:%s/%s/", endpoint.getScheme(), endpoint.getHost(), endpoint.getPort(), "v1");
        PrefixAwareUriTemplateHandler defaultUriTemplateHandler = new PrefixAwareUriTemplateHandler();
        defaultUriTemplateHandler.setBaseUrl(baseUrl);
        return defaultUriTemplateHandler;
    }

    public static class PrefixAwareUriTemplateHandler
    extends DefaultUriTemplateHandler {
        protected URI expandInternal(String uriTemplate, Map<String, ?> uriVariables) {
            return super.expandInternal(this.prepareUriTemplate(uriTemplate), uriVariables);
        }

        protected URI expandInternal(String uriTemplate, Object ... uriVariables) {
            return super.expandInternal(this.prepareUriTemplate(uriTemplate), uriVariables);
        }

        private String prepareUriTemplate(String uriTemplate) {
            if (this.getBaseUrl() != null) {
                if (uriTemplate.startsWith("/") && this.getBaseUrl().endsWith("/")) {
                    return uriTemplate.substring(1);
                }
                if (!uriTemplate.startsWith("/") && !this.getBaseUrl().endsWith("/")) {
                    return "/" + uriTemplate;
                }
                return uriTemplate;
            }
            if (!uriTemplate.startsWith("/")) {
                return "/" + uriTemplate;
            }
            return uriTemplate;
        }
    }
}

