/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.config;

import com.squareup.okhttp.OkHttpClient;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProxySelector;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import okhttp3.OkHttpClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.springframework.core.io.Resource;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.Netty4ClientHttpRequestFactory;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;
import org.springframework.http.client.OkHttpClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.vault.support.ClientOptions;
import org.springframework.vault.support.SslConfiguration;

public class ClientHttpRequestFactoryFactory {
    private static final Log logger = LogFactory.getLog(ClientHttpRequestFactoryFactory.class);
    private static final boolean HTTP_COMPONENTS_PRESENT = ClassUtils.isPresent((String)"org.apache.http.client.HttpClient", (ClassLoader)ClientHttpRequestFactoryFactory.class.getClassLoader());
    private static final boolean OKHTTP_PRESENT = ClassUtils.isPresent((String)"com.squareup.okhttp.OkHttpClient", (ClassLoader)ClientHttpRequestFactoryFactory.class.getClassLoader());
    private static final boolean OKHTTP3_PRESENT = ClassUtils.isPresent((String)"okhttp3.OkHttpClient", (ClassLoader)ClientHttpRequestFactoryFactory.class.getClassLoader());
    private static final boolean NETTY_PRESENT = ClassUtils.isPresent((String)"io.netty.channel.nio.NioEventLoopGroup", (ClassLoader)ClientHttpRequestFactoryFactory.class.getClassLoader());

    public static ClientHttpRequestFactory create(ClientOptions options, SslConfiguration sslConfiguration) {
        Assert.notNull((Object)options, (String)"ClientOptions must not be null");
        Assert.notNull((Object)sslConfiguration, (String)"SslConfiguration must not be null");
        try {
            if (HTTP_COMPONENTS_PRESENT) {
                return HttpComponents.usingHttpComponents(options, sslConfiguration);
            }
            if (OKHTTP3_PRESENT) {
                return OkHttp3.usingOkHttp3(options, sslConfiguration);
            }
            if (OKHTTP_PRESENT) {
                return OkHttp.usingOkHttp(options, sslConfiguration);
            }
            if (NETTY_PRESENT) {
                return Netty.usingNetty(options, sslConfiguration);
            }
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (ClientHttpRequestFactoryFactory.hasSslConfiguration(sslConfiguration)) {
            logger.warn((Object)"VaultProperties has SSL configured but the SSL configuration must be applied outside the Vault Client to use the JDK HTTP client");
        }
        return new SimpleClientHttpRequestFactory();
    }

    static SSLContext getSSLContext(SslConfiguration sslConfiguration) throws GeneralSecurityException, IOException {
        KeyManager[] keyManagers = sslConfiguration.getKeyStore() != null ? ClientHttpRequestFactoryFactory.createKeyManagerFactory(sslConfiguration.getKeyStore(), sslConfiguration.getKeyStorePassword()).getKeyManagers() : null;
        TrustManager[] trustManagers = sslConfiguration.getTrustStore() != null ? ClientHttpRequestFactoryFactory.createTrustManagerFactory(sslConfiguration.getTrustStore(), sslConfiguration.getTrustStorePassword()).getTrustManagers() : null;
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagers, trustManagers, null);
        return sslContext;
    }

    private static KeyManagerFactory createKeyManagerFactory(Resource keystoreFile, String storePassword) throws GeneralSecurityException, IOException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        ClientHttpRequestFactoryFactory.loadKeyStore(keystoreFile, storePassword, keyStore);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, StringUtils.hasText((String)storePassword) ? storePassword.toCharArray() : new char[]{});
        return keyManagerFactory;
    }

    private static TrustManagerFactory createTrustManagerFactory(Resource trustFile, String storePassword) throws GeneralSecurityException, IOException {
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        ClientHttpRequestFactoryFactory.loadKeyStore(trustFile, storePassword, trustStore);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustStore);
        return trustManagerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadKeyStore(Resource keyStoreResource, String storePassword, KeyStore keyStore) throws IOException, NoSuchAlgorithmException, CertificateException {
        InputStream inputStream = null;
        try {
            inputStream = keyStoreResource.getInputStream();
            keyStore.load(inputStream, StringUtils.hasText((String)storePassword) ? storePassword.toCharArray() : null);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private static boolean hasSslConfiguration(SslConfiguration sslConfiguration) {
        return sslConfiguration.getTrustStore() != null || sslConfiguration.getKeyStore() != null;
    }

    static class Netty {
        Netty() {
        }

        static ClientHttpRequestFactory usingNetty(ClientOptions options, SslConfiguration sslConfiguration) throws GeneralSecurityException, IOException {
            Netty4ClientHttpRequestFactory requestFactory = new Netty4ClientHttpRequestFactory();
            if (ClientHttpRequestFactoryFactory.hasSslConfiguration(sslConfiguration)) {
                SslContextBuilder sslContextBuilder = SslContextBuilder.forClient();
                if (sslConfiguration.getTrustStore() != null) {
                    sslContextBuilder.trustManager(ClientHttpRequestFactoryFactory.createTrustManagerFactory(sslConfiguration.getTrustStore(), sslConfiguration.getTrustStorePassword()));
                }
                if (sslConfiguration.getKeyStore() != null) {
                    sslContextBuilder.keyManager(ClientHttpRequestFactoryFactory.createKeyManagerFactory(sslConfiguration.getKeyStore(), sslConfiguration.getKeyStorePassword()));
                }
                requestFactory.setSslContext(sslContextBuilder.sslProvider(SslProvider.JDK).build());
            }
            requestFactory.setConnectTimeout(options.getConnectionTimeout());
            requestFactory.setReadTimeout(options.getReadTimeout());
            return requestFactory;
        }
    }

    static class OkHttp3 {
        OkHttp3() {
        }

        static ClientHttpRequestFactory usingOkHttp3(ClientOptions options, SslConfiguration sslConfiguration) throws GeneralSecurityException, IOException {
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            if (ClientHttpRequestFactoryFactory.hasSslConfiguration(sslConfiguration)) {
                builder.sslSocketFactory(ClientHttpRequestFactoryFactory.getSSLContext(sslConfiguration).getSocketFactory());
            }
            builder.connectTimeout((long)options.getConnectionTimeout(), TimeUnit.MILLISECONDS).readTimeout((long)options.getReadTimeout(), TimeUnit.MILLISECONDS);
            return new OkHttp3ClientHttpRequestFactory(builder.build());
        }
    }

    static class OkHttp {
        OkHttp() {
        }

        static ClientHttpRequestFactory usingOkHttp(ClientOptions options, SslConfiguration sslConfiguration) throws GeneralSecurityException, IOException {
            final OkHttpClient okHttpClient = new OkHttpClient();
            OkHttpClientHttpRequestFactory requestFactory = new OkHttpClientHttpRequestFactory(okHttpClient){

                public void destroy() throws IOException {
                    if (okHttpClient.getCache() != null) {
                        okHttpClient.getCache().close();
                    }
                    okHttpClient.getDispatcher().getExecutorService().shutdown();
                }
            };
            if (ClientHttpRequestFactoryFactory.hasSslConfiguration(sslConfiguration)) {
                okHttpClient.setSslSocketFactory(ClientHttpRequestFactoryFactory.getSSLContext(sslConfiguration).getSocketFactory());
            }
            requestFactory.setConnectTimeout(options.getConnectionTimeout());
            requestFactory.setReadTimeout(options.getReadTimeout());
            return requestFactory;
        }
    }

    static class HttpComponents {
        HttpComponents() {
        }

        static ClientHttpRequestFactory usingHttpComponents(ClientOptions options, SslConfiguration sslConfiguration) throws GeneralSecurityException, IOException {
            HttpClientBuilder httpClientBuilder = HttpClients.custom();
            httpClientBuilder.setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner((SchemePortResolver)DefaultSchemePortResolver.INSTANCE, ProxySelector.getDefault()));
            if (ClientHttpRequestFactoryFactory.hasSslConfiguration(sslConfiguration)) {
                SSLContext sslContext = ClientHttpRequestFactoryFactory.getSSLContext(sslConfiguration);
                SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext);
                httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory);
                httpClientBuilder.setSSLContext(sslContext);
            }
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(options.getConnectionTimeout()).setSocketTimeout(options.getReadTimeout()).setAuthenticationEnabled(true).build();
            httpClientBuilder.setDefaultRequestConfig(requestConfig);
            return new HttpComponentsClientHttpRequestFactory((HttpClient)httpClientBuilder.build());
        }
    }
}

