/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.config;

import java.net.URI;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.vault.authentication.AppIdAuthentication;
import org.springframework.vault.authentication.AppIdAuthenticationOptions;
import org.springframework.vault.authentication.AppIdUserIdMechanism;
import org.springframework.vault.authentication.AppRoleAuthentication;
import org.springframework.vault.authentication.AppRoleAuthenticationOptions;
import org.springframework.vault.authentication.AwsEc2Authentication;
import org.springframework.vault.authentication.AwsEc2AuthenticationOptions;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.ClientCertificateAuthentication;
import org.springframework.vault.authentication.CubbyholeAuthentication;
import org.springframework.vault.authentication.CubbyholeAuthenticationOptions;
import org.springframework.vault.authentication.IpAddressUserId;
import org.springframework.vault.authentication.MacAddressUserId;
import org.springframework.vault.authentication.StaticUserId;
import org.springframework.vault.authentication.TokenAuthentication;
import org.springframework.vault.client.VaultEndpoint;
import org.springframework.vault.config.AbstractVaultConfiguration;
import org.springframework.vault.support.SslConfiguration;
import org.springframework.vault.support.VaultToken;
import org.springframework.web.client.RestOperations;

@Configuration
public class EnvironmentVaultConfiguration
extends AbstractVaultConfiguration
implements ApplicationContextAware {
    private RestOperations cachedRestOperations;
    private ApplicationContext applicationContext;

    @Override
    public RestOperations restOperations() {
        if (this.cachedRestOperations != null) {
            return this.cachedRestOperations;
        }
        this.cachedRestOperations = super.restOperations();
        return this.cachedRestOperations;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        super.setApplicationContext(applicationContext);
    }

    @Override
    public VaultEndpoint vaultEndpoint() {
        String uri = this.getProperty("vault.uri");
        if (uri != null) {
            return VaultEndpoint.from(URI.create(uri));
        }
        throw new IllegalStateException("Vault URI (vault.uri) is null");
    }

    @Override
    public SslConfiguration sslConfiguration() {
        Resource keyStore = this.getResource("vault.ssl.key-store");
        String keyStorePassword = this.getProperty("vault.ssl.key-store-password");
        Resource trustStore = this.getResource("vault.ssl.trust-store");
        String trustStorePassword = this.getProperty("vault.ssl.trust-store-password");
        return new SslConfiguration(keyStore, keyStorePassword, trustStore, trustStorePassword);
    }

    @Override
    public ClientAuthentication clientAuthentication() {
        String authentication = this.getEnvironment().getProperty("vault.authentication", AuthenticationMethod.TOKEN.name()).toUpperCase().replace('-', '_');
        AuthenticationMethod authenticationMethod = AuthenticationMethod.valueOf(authentication);
        switch (authenticationMethod) {
            case TOKEN: {
                return this.tokenAuthentication();
            }
            case APPID: {
                return this.appIdAuthentication();
            }
            case APPROLE: {
                return this.appRoleAuthentication();
            }
            case AWS_EC2: {
                return this.awsEc2Authentication();
            }
            case CERT: {
                return new ClientCertificateAuthentication(this.restOperations());
            }
            case CUBBYHOLE: {
                return this.cubbyholeAuthentication();
            }
        }
        throw new IllegalStateException(String.format("Vault authentication method %s is not supported with %s", new Object[]{authenticationMethod, this.getClass().getSimpleName()}));
    }

    protected ClientAuthentication tokenAuthentication() {
        String token = this.getProperty("vault.token");
        Assert.hasText((String)token, (String)"Vault Token authentication: Token (vault.token) must not be empty");
        return new TokenAuthentication(token);
    }

    protected ClientAuthentication appIdAuthentication() {
        String appId = this.getEnvironment().getProperty("vault.app-id.app-id", this.getProperty("spring.application.name"));
        String userId = this.getProperty("vault.app-id.user-id");
        Assert.hasText((String)appId, (String)"Vault AppId authentication: AppId (vault.app-id.app-id) must not be empty");
        Assert.hasText((String)userId, (String)"Vault AppId authentication: UserId (vault.app-id.user-id) must not be empty");
        AppIdAuthenticationOptions authenticationOptions = AppIdAuthenticationOptions.builder().appId(appId).userIdMechanism(this.getAppIdUserIdMechanism(userId)).build();
        return new AppIdAuthentication(authenticationOptions, this.restOperations());
    }

    protected ClientAuthentication appRoleAuthentication() {
        String roleId = this.getProperty("vault.app-role.role-id");
        String secretId = this.getProperty("vault.app-role.secret-id");
        Assert.hasText((String)roleId, (String)"Vault AppRole authentication: RoleId (vault.app-role.role-id) must not be empty");
        AppRoleAuthenticationOptions.AppRoleAuthenticationOptionsBuilder builder = AppRoleAuthenticationOptions.builder().roleId(roleId);
        if (StringUtils.hasText((String)secretId)) {
            builder = builder.secretId(secretId);
        }
        return new AppRoleAuthentication(builder.build(), this.restOperations());
    }

    protected AppIdUserIdMechanism getAppIdUserIdMechanism(String userId) {
        if (userId.equalsIgnoreCase(AppIdUserId.IP_ADDRESS.name())) {
            return new IpAddressUserId();
        }
        if (userId.equalsIgnoreCase(AppIdUserId.MAC_ADDRESS.name())) {
            return new MacAddressUserId();
        }
        return new StaticUserId(userId);
    }

    protected ClientAuthentication awsEc2Authentication() {
        String roleId = this.getProperty("vault.aws-ec2.role-id");
        String identityDocument = this.getProperty("vault.aws-ec2.identity-document");
        Assert.hasText((String)roleId, (String)"Vault AWS EC2 authentication: RoleId (vault.aws-ec2.role-id) must not be empty");
        AwsEc2AuthenticationOptions.AwsEc2AuthenticationOptionsBuilder builder = AwsEc2AuthenticationOptions.builder().role(roleId);
        if (StringUtils.hasText((String)identityDocument)) {
            builder.identityDocumentUri(URI.create(identityDocument));
        }
        return new AwsEc2Authentication(builder.build(), this.restOperations(), this.restOperations());
    }

    protected ClientAuthentication cubbyholeAuthentication() {
        String token = this.getProperty("vault.token");
        Assert.hasText((String)token, (String)"Vault Cubbyhole authentication: Initial token (vault.token) must not be empty");
        CubbyholeAuthenticationOptions options = CubbyholeAuthenticationOptions.builder().wrapped().initialToken(VaultToken.of(token)).build();
        return new CubbyholeAuthentication(options, this.restOperations());
    }

    private String getProperty(String key) {
        return this.getEnvironment().getProperty(key);
    }

    private Resource getResource(String key) {
        String value = this.getProperty(key);
        return value != null ? this.applicationContext.getResource(value) : null;
    }

    static enum AuthenticationMethod {
        TOKEN,
        APPID,
        APPROLE,
        AWS_EC2,
        CERT,
        CUBBYHOLE;

    }

    static enum AppIdUserId {
        IP_ADDRESS,
        MAC_ADDRESS;

    }
}

