/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.core;

import java.util.HashMap;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.vault.VaultException;
import org.springframework.vault.client.VaultResponses;
import org.springframework.vault.core.RestOperationsCallback;
import org.springframework.vault.core.VaultOperations;
import org.springframework.vault.core.VaultPkiOperations;
import org.springframework.vault.support.VaultCertificateRequest;
import org.springframework.vault.support.VaultCertificateResponse;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestOperations;

public class VaultPkiTemplate
implements VaultPkiOperations {
    private final VaultOperations vaultOperations;
    private final String path;

    public VaultPkiTemplate(VaultOperations vaultOperations, String path) {
        Assert.notNull((Object)vaultOperations, (String)"VaultOperations must not be null");
        Assert.hasText((String)path, (String)"Path must not be empty");
        this.vaultOperations = vaultOperations;
        this.path = path;
    }

    @Override
    public VaultCertificateResponse issueCertificate(final String roleName, VaultCertificateRequest certificateRequest) throws VaultException {
        Assert.hasText((String)roleName, (String)"Role name must not be empty");
        Assert.notNull((Object)certificateRequest, (String)"Certificate request must not be null");
        final HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("common_name", certificateRequest.getCommonName());
        if (!certificateRequest.getAltNames().isEmpty()) {
            request.put("alt_names", StringUtils.collectionToDelimitedString(certificateRequest.getAltNames(), (String)","));
        }
        if (!certificateRequest.getIpSubjectAltNames().isEmpty()) {
            request.put("ip_sans", StringUtils.collectionToDelimitedString(certificateRequest.getIpSubjectAltNames(), (String)","));
        }
        if (certificateRequest.getTtl() != null) {
            request.put("ttl", certificateRequest.getTtl());
        }
        request.put("format", "der");
        if (certificateRequest.isExcludeCommonNameFromSubjectAltNames()) {
            request.put("exclude_cn_from_sans", true);
        }
        return this.vaultOperations.doWithSession(new RestOperationsCallback<VaultCertificateResponse>(){

            @Override
            public VaultCertificateResponse doWithRestOperations(RestOperations restOperations) {
                try {
                    return (VaultCertificateResponse)restOperations.postForObject("{path}/issue/{roleName}", (Object)request, VaultCertificateResponse.class, new Object[]{VaultPkiTemplate.this.path, roleName});
                }
                catch (HttpStatusCodeException e) {
                    throw VaultResponses.buildException(e);
                }
            }
        });
    }
}

