/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.core;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.Assert;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.SessionManager;
import org.springframework.vault.authentication.SimpleSessionManager;
import org.springframework.vault.client.VaultClients;
import org.springframework.vault.client.VaultEndpoint;
import org.springframework.vault.client.VaultResponses;
import org.springframework.vault.core.RestOperationsCallback;
import org.springframework.vault.core.VaultOperations;
import org.springframework.vault.core.VaultPkiOperations;
import org.springframework.vault.core.VaultPkiTemplate;
import org.springframework.vault.core.VaultSysOperations;
import org.springframework.vault.core.VaultSysTemplate;
import org.springframework.vault.core.VaultTokenOperations;
import org.springframework.vault.core.VaultTokenTemplate;
import org.springframework.vault.core.VaultTransitOperations;
import org.springframework.vault.core.VaultTransitTemplate;
import org.springframework.vault.support.VaultResponse;
import org.springframework.vault.support.VaultResponseSupport;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class VaultTemplate
implements InitializingBean,
VaultOperations,
DisposableBean {
    private SessionManager sessionManager;
    private RestTemplate sessionTemplate;
    private RestTemplate plainTemplate;
    private final boolean dedicatedSessionManager;

    public VaultTemplate() {
        this.dedicatedSessionManager = false;
    }

    public VaultTemplate(VaultEndpoint vaultEndpoint, ClientAuthentication clientAuthentication) {
        Assert.notNull((Object)vaultEndpoint, (String)"VaultEndpoint must not be null");
        Assert.notNull((Object)clientAuthentication, (String)"ClientAuthentication must not be null");
        this.sessionManager = new SimpleSessionManager(clientAuthentication);
        this.dedicatedSessionManager = true;
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        this.sessionTemplate = this.createSessionTemplate(vaultEndpoint, (ClientHttpRequestFactory)requestFactory);
        this.plainTemplate = VaultClients.createRestTemplate(vaultEndpoint, (ClientHttpRequestFactory)requestFactory);
    }

    public VaultTemplate(VaultEndpoint vaultEndpoint, ClientHttpRequestFactory clientHttpRequestFactory, SessionManager sessionManager) {
        Assert.notNull((Object)vaultEndpoint, (String)"VaultEndpoint must not be null");
        Assert.notNull((Object)clientHttpRequestFactory, (String)"ClientHttpRequestFactory must not be null");
        Assert.notNull((Object)sessionManager, (String)"SessionManager must not be null");
        this.sessionManager = sessionManager;
        this.dedicatedSessionManager = false;
        this.sessionTemplate = this.createSessionTemplate(vaultEndpoint, clientHttpRequestFactory);
        this.plainTemplate = VaultClients.createRestTemplate(vaultEndpoint, clientHttpRequestFactory);
    }

    private RestTemplate createSessionTemplate(VaultEndpoint endpoint, ClientHttpRequestFactory requestFactory) {
        RestTemplate restTemplate = VaultClients.createRestTemplate(endpoint, requestFactory);
        restTemplate.getInterceptors().add(new ClientHttpRequestInterceptor(){

            public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
                request.getHeaders().add("X-Vault-Token", VaultTemplate.this.sessionManager.getSessionToken().getToken());
                return execution.execute(request, body);
            }
        });
        return restTemplate;
    }

    public void setSessionManager(SessionManager sessionManager) {
        Assert.notNull((Object)sessionManager, (String)"SessionManager must not be null");
        this.sessionManager = sessionManager;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.sessionManager, (String)"SessionManager must not be null");
    }

    public void destroy() throws Exception {
        if (this.dedicatedSessionManager && this.sessionManager instanceof DisposableBean) {
            ((DisposableBean)this.sessionManager).destroy();
        }
    }

    @Override
    public VaultSysOperations opsForSys() {
        return new VaultSysTemplate(this);
    }

    @Override
    public VaultTokenOperations opsForToken() {
        return new VaultTokenTemplate(this);
    }

    @Override
    public VaultTransitOperations opsForTransit() {
        return this.opsForTransit("transit");
    }

    @Override
    public VaultTransitOperations opsForTransit(String path) {
        return new VaultTransitTemplate(this, path);
    }

    @Override
    public VaultPkiOperations opsForPki() {
        return this.opsForPki("pki");
    }

    @Override
    public VaultPkiOperations opsForPki(String path) {
        return new VaultPkiTemplate(this, path);
    }

    @Override
    public VaultResponse read(String path) {
        Assert.hasText((String)path, (String)"Path must not be empty");
        return this.doRead(path, VaultResponse.class);
    }

    @Override
    public <T> VaultResponseSupport<T> read(String path, Class<T> responseType) {
        ParameterizedTypeReference<VaultResponseSupport<T>> ref = VaultResponses.getTypeReference(responseType);
        try {
            ResponseEntity exchange = this.sessionTemplate.exchange(path, HttpMethod.GET, null, ref, new Object[0]);
            return (VaultResponseSupport)exchange.getBody();
        }
        catch (HttpStatusCodeException e) {
            if (e.getStatusCode() == HttpStatus.NOT_FOUND) {
                return null;
            }
            throw VaultResponses.buildException(e, path);
        }
    }

    @Override
    public List<String> list(String path) {
        Assert.hasText((String)path, (String)"Path must not be empty");
        VaultListResponse read = this.doRead(String.format("%s?list=true", path.endsWith("/") ? path : path + "/"), VaultListResponse.class);
        if (read == null) {
            return Collections.emptyList();
        }
        return (List)((Map)read.getData()).get("keys");
    }

    @Override
    public VaultResponse write(String path, Object body) {
        Assert.hasText((String)path, (String)"Path must not be empty");
        try {
            return (VaultResponse)this.sessionTemplate.postForObject(path, body, VaultResponse.class, new Object[0]);
        }
        catch (HttpStatusCodeException e) {
            throw VaultResponses.buildException(e, path);
        }
    }

    @Override
    public void delete(String path) {
        Assert.hasText((String)path, (String)"Path must not be empty");
        try {
            this.sessionTemplate.delete(path, new Object[0]);
        }
        catch (HttpStatusCodeException e) {
            if (e.getStatusCode() == HttpStatus.NOT_FOUND) {
                return;
            }
            throw VaultResponses.buildException(e, path);
        }
    }

    @Override
    public <T> T doWithVault(RestOperationsCallback<T> clientCallback) {
        Assert.notNull(clientCallback, (String)"Client callback must not be null");
        try {
            return clientCallback.doWithRestOperations((RestOperations)this.plainTemplate);
        }
        catch (HttpStatusCodeException e) {
            throw VaultResponses.buildException(e);
        }
    }

    @Override
    public <T> T doWithSession(RestOperationsCallback<T> sessionCallback) {
        Assert.notNull(sessionCallback, (String)"Session callback must not be null");
        try {
            return sessionCallback.doWithRestOperations((RestOperations)this.sessionTemplate);
        }
        catch (HttpStatusCodeException e) {
            throw VaultResponses.buildException(e);
        }
    }

    private <T> T doRead(final String path, final Class<T> responseType) {
        return this.doWithSession(new RestOperationsCallback<T>(){

            @Override
            public T doWithRestOperations(RestOperations restOperations) {
                try {
                    return restOperations.getForObject(path, responseType, new Object[0]);
                }
                catch (HttpStatusCodeException e) {
                    if (e.getStatusCode() == HttpStatus.NOT_FOUND) {
                        return null;
                    }
                    throw VaultResponses.buildException(e, path);
                }
            }
        });
    }

    private static class VaultListResponse
    extends VaultResponseSupport<Map<String, Object>> {
        private VaultListResponse() {
        }
    }
}

