/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.core;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.Base64Utils;
import org.springframework.vault.core.VaultOperations;
import org.springframework.vault.core.VaultTransitOperations;
import org.springframework.vault.support.VaultResponse;
import org.springframework.vault.support.VaultResponseSupport;
import org.springframework.vault.support.VaultTransitContext;
import org.springframework.vault.support.VaultTransitKey;
import org.springframework.vault.support.VaultTransitKeyConfiguration;
import org.springframework.vault.support.VaultTransitKeyCreationRequest;

public class VaultTransitTemplate
implements VaultTransitOperations {
    private final VaultOperations vaultOperations;
    private final String path;

    public VaultTransitTemplate(VaultOperations vaultOperations, String path) {
        Assert.notNull((Object)vaultOperations, (String)"VaultOperations must not be null");
        Assert.hasText((String)path, (String)"Path must not be empty");
        this.vaultOperations = vaultOperations;
        this.path = path;
    }

    @Override
    public void createKey(String keyName) {
        Assert.hasText((String)keyName, (String)"KeyName must not be empty");
        this.vaultOperations.write(String.format("%s/keys/%s", this.path, keyName), null);
    }

    @Override
    public void createKey(String keyName, VaultTransitKeyCreationRequest createKeyRequest) {
        Assert.hasText((String)keyName, (String)"KeyName must not be empty");
        Assert.notNull((Object)createKeyRequest, (String)"VaultTransitKeyCreationRequest must not be empty");
        this.vaultOperations.write(String.format("%s/keys/%s", this.path, keyName), createKeyRequest);
    }

    @Override
    public List<String> getKeys() {
        VaultResponse response = this.vaultOperations.read(String.format("%s/keys?list=true", this.path));
        return response == null ? Collections.emptyList() : (List)((Map)response.getData()).get("keys");
    }

    @Override
    public void configureKey(String keyName, VaultTransitKeyConfiguration keyConfiguration) {
        Assert.hasText((String)keyName, (String)"KeyName must not be empty");
        Assert.notNull((Object)keyConfiguration, (String)"VaultKeyConfiguration must not be empty");
        this.vaultOperations.write(String.format("%s/keys/%s/config", this.path, keyName), keyConfiguration);
    }

    @Override
    public VaultTransitKey getKey(String keyName) {
        Assert.hasText((String)keyName, (String)"KeyName must not be empty");
        VaultResponseSupport<VaultTransitKeyImpl> result = this.vaultOperations.read(String.format("%s/keys/%s", this.path, keyName), VaultTransitKeyImpl.class);
        if (result != null) {
            return result.getData();
        }
        return null;
    }

    @Override
    public void deleteKey(String keyName) {
        Assert.hasText((String)keyName, (String)"KeyName must not be empty");
        this.vaultOperations.delete(String.format("%s/keys/%s", this.path, keyName));
    }

    @Override
    public void rotate(String keyName) {
        Assert.hasText((String)keyName, (String)"KeyName must not be empty");
        this.vaultOperations.write(String.format("%s/keys/%s/rotate", this.path, keyName), null);
    }

    @Override
    public String encrypt(String keyName, String plaintext) {
        Assert.hasText((String)keyName, (String)"KeyName must not be empty");
        Assert.notNull((Object)plaintext, (String)"Plain text must not be null");
        LinkedHashMap<String, String> request = new LinkedHashMap<String, String>();
        request.put("plaintext", Base64Utils.encodeToString((byte[])plaintext.getBytes()));
        return (String)((Map)this.vaultOperations.write(String.format("%s/encrypt/%s", this.path, keyName), request).getData()).get("ciphertext");
    }

    @Override
    public String encrypt(String keyName, byte[] plaintext, VaultTransitContext transitRequest) {
        Assert.hasText((String)keyName, (String)"KeyName must not be empty");
        Assert.notNull((Object)plaintext, (String)"Plain text must not be null");
        LinkedHashMap<String, String> request = new LinkedHashMap<String, String>();
        request.put("plaintext", Base64Utils.encodeToString((byte[])plaintext));
        if (transitRequest != null) {
            this.applyTransitOptions(transitRequest, request);
        }
        return (String)((Map)this.vaultOperations.write(String.format("%s/encrypt/%s", this.path, keyName), request).getData()).get("ciphertext");
    }

    @Override
    public String decrypt(String keyName, String ciphertext) {
        Assert.hasText((String)keyName, (String)"KeyName must not be empty");
        Assert.hasText((String)keyName, (String)"Cipher text must not be empty");
        LinkedHashMap<String, String> request = new LinkedHashMap<String, String>();
        request.put("ciphertext", ciphertext);
        String plaintext = (String)((Map)this.vaultOperations.write(String.format("%s/decrypt/%s", this.path, keyName), request).getData()).get("plaintext");
        return new String(Base64Utils.decodeFromString((String)plaintext));
    }

    @Override
    public byte[] decrypt(String keyName, String ciphertext, VaultTransitContext transitRequest) {
        Assert.hasText((String)keyName, (String)"KeyName must not be empty");
        Assert.hasText((String)keyName, (String)"Cipher text must not be empty");
        LinkedHashMap<String, String> request = new LinkedHashMap<String, String>();
        request.put("ciphertext", ciphertext);
        if (transitRequest != null) {
            this.applyTransitOptions(transitRequest, request);
        }
        String plaintext = (String)((Map)this.vaultOperations.write(String.format("%s/decrypt/%s", this.path, keyName), request).getData()).get("plaintext");
        return Base64Utils.decodeFromString((String)plaintext);
    }

    @Override
    public String rewrap(String keyName, String ciphertext) {
        Assert.hasText((String)keyName, (String)"KeyName must not be empty");
        Assert.hasText((String)ciphertext, (String)"Cipher text must not be empty");
        LinkedHashMap<String, String> request = new LinkedHashMap<String, String>();
        request.put("ciphertext", ciphertext);
        return (String)((Map)this.vaultOperations.write(String.format("%s/rewrap/%s", this.path, keyName), request).getData()).get("ciphertext");
    }

    @Override
    public String rewrap(String keyName, String ciphertext, VaultTransitContext transitRequest) {
        Assert.hasText((String)keyName, (String)"KeyName must not be empty");
        Assert.hasText((String)ciphertext, (String)"Cipher text must not be empty");
        LinkedHashMap<String, String> request = new LinkedHashMap<String, String>();
        request.put("ciphertext", ciphertext);
        if (transitRequest != null) {
            this.applyTransitOptions(transitRequest, request);
        }
        return (String)((Map)this.vaultOperations.write(String.format("%s/rewrap/%s", this.path, keyName), request).getData()).get("ciphertext");
    }

    private void applyTransitOptions(VaultTransitContext transitRequest, Map<String, String> request) {
        if (transitRequest.getContext() != null) {
            request.put("context", Base64Utils.encodeToString((byte[])transitRequest.getContext()));
        }
        if (transitRequest.getNonce() != null) {
            request.put("nonce", Base64Utils.encodeToString((byte[])transitRequest.getNonce()));
        }
    }

    static class VaultTransitKeyImpl
    implements VaultTransitKey {
        @JsonProperty(value="cipher_mode")
        private String cipherMode;
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="deletion_allowed")
        private boolean deletionAllowed;
        private boolean derived;
        private Map<String, Long> keys;
        @JsonProperty(value="latest_version")
        private boolean latestVersion;
        @JsonProperty(value="min_decryption_version")
        private int minDecryptionVersion;
        private String name;

        @Override
        public String getType() {
            if (this.type != null) {
                return this.type;
            }
            return this.cipherMode;
        }

        public String getCipherMode() {
            return this.cipherMode;
        }

        @Override
        public boolean isDeletionAllowed() {
            return this.deletionAllowed;
        }

        @Override
        public boolean isDerived() {
            return this.derived;
        }

        @Override
        public Map<String, Long> getKeys() {
            return this.keys;
        }

        @Override
        public boolean isLatestVersion() {
            return this.latestVersion;
        }

        @Override
        public int getMinDecryptionVersion() {
            return this.minDecryptionVersion;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void setCipherMode(String cipherMode) {
            this.cipherMode = cipherMode;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setDeletionAllowed(boolean deletionAllowed) {
            this.deletionAllowed = deletionAllowed;
        }

        public void setDerived(boolean derived) {
            this.derived = derived;
        }

        public void setKeys(Map<String, Long> keys) {
            this.keys = keys;
        }

        public void setLatestVersion(boolean latestVersion) {
            this.latestVersion = latestVersion;
        }

        public void setMinDecryptionVersion(int minDecryptionVersion) {
            this.minDecryptionVersion = minDecryptionVersion;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VaultTransitKeyImpl)) {
                return false;
            }
            VaultTransitKeyImpl other = (VaultTransitKeyImpl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$cipherMode = this.getCipherMode();
            String other$cipherMode = other.getCipherMode();
            if (this$cipherMode == null ? other$cipherMode != null : !this$cipherMode.equals(other$cipherMode)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            if (this.isDeletionAllowed() != other.isDeletionAllowed()) {
                return false;
            }
            if (this.isDerived() != other.isDerived()) {
                return false;
            }
            Map<String, Long> this$keys = this.getKeys();
            Map<String, Long> other$keys = other.getKeys();
            if (this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys)) {
                return false;
            }
            if (this.isLatestVersion() != other.isLatestVersion()) {
                return false;
            }
            if (this.getMinDecryptionVersion() != other.getMinDecryptionVersion()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof VaultTransitKeyImpl;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $cipherMode = this.getCipherMode();
            result = result * 59 + ($cipherMode == null ? 43 : $cipherMode.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            result = result * 59 + (this.isDeletionAllowed() ? 79 : 97);
            result = result * 59 + (this.isDerived() ? 79 : 97);
            Map<String, Long> $keys = this.getKeys();
            result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
            result = result * 59 + (this.isLatestVersion() ? 79 : 97);
            result = result * 59 + this.getMinDecryptionVersion();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "VaultTransitTemplate.VaultTransitKeyImpl(cipherMode=" + this.getCipherMode() + ", type=" + this.getType() + ", deletionAllowed=" + this.isDeletionAllowed() + ", derived=" + this.isDerived() + ", keys=" + this.getKeys() + ", latestVersion=" + this.isLatestVersion() + ", minDecryptionVersion=" + this.getMinDecryptionVersion() + ", name=" + this.getName() + ")";
        }
    }
}

