/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.core.env;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.util.Assert;
import org.springframework.vault.VaultException;
import org.springframework.vault.core.VaultOperations;
import org.springframework.vault.core.util.PropertyTransformer;
import org.springframework.vault.core.util.PropertyTransformers;
import org.springframework.vault.support.JsonMapFlattener;
import org.springframework.vault.support.VaultResponse;

public class VaultPropertySource
extends EnumerablePropertySource<VaultOperations> {
    private static final Log logger = LogFactory.getLog(VaultPropertySource.class);
    private final String path;
    private final Map<String, String> properties = new LinkedHashMap<String, String>();
    private final PropertyTransformer propertyTransformer;
    private final Object lock = new Object();

    public VaultPropertySource(VaultOperations vaultOperations, String path) {
        this(path, vaultOperations, path);
    }

    public VaultPropertySource(String name, VaultOperations vaultOperations, String path) {
        this(name, vaultOperations, path, PropertyTransformers.noop());
    }

    public VaultPropertySource(String name, VaultOperations vaultOperations, String path, PropertyTransformer propertyTransformer) {
        super(name, (Object)vaultOperations);
        Assert.hasText((String)path, (String)"Path name must contain at least one character");
        Assert.isTrue((!path.startsWith("/") ? 1 : 0) != 0, (String)"Path name must not start with a slash (/)");
        Assert.notNull((Object)propertyTransformer, (String)"PropertyTransformer must not be null");
        this.path = path;
        this.propertyTransformer = propertyTransformer.andThen(PropertyTransformers.removeNullProperties());
        this.loadProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadProperties() {
        Object object = this.lock;
        synchronized (object) {
            Map<String, String> properties;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Fetching properties from Vault at %s", this.path));
            }
            if ((properties = this.doGetProperties(this.path)) != null) {
                this.properties.putAll(this.doTransformProperties(properties));
            }
        }
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public String[] getPropertyNames() {
        Set<String> strings = this.properties.keySet();
        return strings.toArray(new String[strings.size()]);
    }

    protected Map<String, String> doGetProperties(String path) throws VaultException {
        VaultResponse vaultResponse = ((VaultOperations)this.source).read(path);
        if (vaultResponse == null || vaultResponse.getData() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("No properties found at %s", path));
            }
            return null;
        }
        return this.toStringMap((Map)vaultResponse.getData());
    }

    protected Map<String, String> doTransformProperties(Map<String, String> properties) {
        return this.propertyTransformer.transformProperties(properties);
    }

    protected Map<String, String> toStringMap(Map<String, Object> data) {
        return JsonMapFlattener.flatten(data);
    }
}

