/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.core.util;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.vault.core.util.PropertyTransformer;

public abstract class PropertyTransformers {
    public static PropertyTransformer noop() {
        return NoOpPropertyTransformer.instance();
    }

    public static PropertyTransformer removeNullProperties() {
        return RemoveNullProperties.instance();
    }

    public static PropertyTransformer propertyNamePrefix(String propertyNamePrefix) {
        return KeyPrefixPropertyTransformer.forPrefix(propertyNamePrefix);
    }

    static class KeyPrefixPropertyTransformer
    extends PropertyTransformerSupport {
        private final String propertyNamePrefix;

        private KeyPrefixPropertyTransformer(String propertyNamePrefix) {
            Assert.notNull((Object)propertyNamePrefix, (String)"Property name prefix must not be null");
            this.propertyNamePrefix = propertyNamePrefix;
        }

        public static PropertyTransformer forPrefix(String propertyNamePrefix) {
            return new KeyPrefixPropertyTransformer(propertyNamePrefix);
        }

        @Override
        public Map<String, String> transformProperties(Map<String, String> input) {
            LinkedHashMap<String, String> target = new LinkedHashMap<String, String>(input.size(), 1.0f);
            for (Map.Entry<String, String> entry : input.entrySet()) {
                target.put(this.propertyNamePrefix + entry.getKey(), entry.getValue());
            }
            return target;
        }
    }

    static class RemoveNullProperties
    extends PropertyTransformerSupport {
        static RemoveNullProperties INSTANCE = new RemoveNullProperties();

        private RemoveNullProperties() {
        }

        public static PropertyTransformer instance() {
            return INSTANCE;
        }

        @Override
        public Map<String, String> transformProperties(Map<String, String> input) {
            LinkedHashMap<String, String> target = new LinkedHashMap<String, String>(input.size(), 1.0f);
            for (Map.Entry<String, String> entry : input.entrySet()) {
                if (entry.getValue() == null) continue;
                target.put(entry.getKey(), entry.getValue());
            }
            return target;
        }
    }

    static class NoOpPropertyTransformer
    extends PropertyTransformerSupport {
        static NoOpPropertyTransformer INSTANCE = new NoOpPropertyTransformer();

        private NoOpPropertyTransformer() {
        }

        public static PropertyTransformer instance() {
            return INSTANCE;
        }

        @Override
        public Map<String, String> transformProperties(Map<String, String> input) {
            return input;
        }
    }

    static abstract class PropertyTransformerSupport
    implements PropertyTransformer {
        PropertyTransformerSupport() {
        }

        @Override
        public PropertyTransformer andThen(final PropertyTransformer after) {
            final PropertyTransformerSupport that = this;
            return new PropertyTransformerSupport(){

                @Override
                public Map<String, String> transformProperties(Map<String, String> input) {
                    Map<String, String> processed = that.transformProperties(input);
                    return after.transformProperties(processed);
                }
            };
        }
    }
}

