/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.support;

import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class SslConfiguration {
    public static final SslConfiguration NONE = new SslConfiguration(null, null, null, null);
    private final Resource keyStore;
    private final String keyStorePassword;
    private final Resource trustStore;
    private final String trustStorePassword;

    public SslConfiguration(Resource keyStore, String keyStorePassword, Resource trustStore, String trustStorePassword) {
        this.keyStore = keyStore;
        this.keyStorePassword = keyStorePassword;
        this.trustStore = trustStore;
        this.trustStorePassword = trustStorePassword;
    }

    public static SslConfiguration forTrustStore(Resource trustStore, String trustStorePassword) {
        Assert.notNull((Object)trustStore, (String)"TrustStore must not be null");
        Assert.notNull((Object)trustStore.exists(), (String)String.format("TrustStore %s does not exist", trustStore));
        return new SslConfiguration(null, null, trustStore, trustStorePassword);
    }

    public static SslConfiguration forKeyStore(Resource keyStore, String keyStorePassword) {
        Assert.notNull((Object)keyStore, (String)"KeyStore must not be null");
        Assert.notNull((Object)keyStore.exists(), (String)String.format("KeyStore %s does not exist", keyStore));
        return new SslConfiguration(keyStore, keyStorePassword, null, null);
    }

    public SslConfiguration create(Resource keyStore, String keyStorePassword, Resource trustStore, String trustStorePassword) {
        Assert.notNull((Object)keyStore, (String)"KeyStore must not be null");
        Assert.notNull((Object)keyStore.exists(), (String)String.format("KeyStore %s does not exist", trustStore));
        Assert.notNull((Object)trustStore, (String)"TrustStore must not be null");
        Assert.notNull((Object)trustStore.exists(), (String)String.format("TrustStore %s does not exist", trustStore));
        return new SslConfiguration(keyStore, keyStorePassword, trustStore, trustStorePassword);
    }

    public Resource getKeyStore() {
        return this.keyStore;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public Resource getTrustStore() {
        return this.trustStore;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }
}

