/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.support;

import com.fasterxml.jackson.annotation.JsonProperty;

public class VaultTransitKeyConfiguration {
    @JsonProperty(value="deletion_allowed")
    private final Boolean deletionAllowed;
    @JsonProperty(value="latest_version")
    private final Integer latestVersion;

    private VaultTransitKeyConfiguration(Boolean deletionAllowed, Integer latestVersion) {
        this.deletionAllowed = deletionAllowed;
        this.latestVersion = latestVersion;
    }

    public static VaultTransitKeyConfigurationBuilder builder() {
        return new VaultTransitKeyConfigurationBuilder();
    }

    public Boolean getDeletionAllowed() {
        return this.deletionAllowed;
    }

    public Integer getLatestVersion() {
        return this.latestVersion;
    }

    public static class VaultTransitKeyConfigurationBuilder {
        private Boolean deletionAllowed;
        private Integer latestVersion;

        VaultTransitKeyConfigurationBuilder() {
        }

        public VaultTransitKeyConfigurationBuilder deletionAllowed(boolean deletionAllowed) {
            this.deletionAllowed = deletionAllowed;
            return this;
        }

        public VaultTransitKeyConfigurationBuilder latestVersion(int latestVersion) {
            this.latestVersion = latestVersion;
            return this;
        }

        public VaultTransitKeyConfiguration build() {
            return new VaultTransitKeyConfiguration(this.deletionAllowed, this.latestVersion);
        }
    }
}

