/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.authentication;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.vault.VaultException;
import org.springframework.vault.authentication.AppRoleAuthenticationOptions;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.LoginTokenUtil;
import org.springframework.vault.client.VaultResponses;
import org.springframework.vault.support.VaultResponse;
import org.springframework.vault.support.VaultToken;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestOperations;

public class AppRoleAuthentication
implements ClientAuthentication {
    private static final Log logger = LogFactory.getLog(AppRoleAuthentication.class);
    private final AppRoleAuthenticationOptions options;
    private final RestOperations restOperations;

    public AppRoleAuthentication(AppRoleAuthenticationOptions options, RestOperations restOperations) {
        Assert.notNull((Object)options, (String)"AppRoleAuthenticationOptions must not be null");
        Assert.notNull((Object)restOperations, (String)"RestOperations must not be null");
        this.options = options;
        this.restOperations = restOperations;
    }

    @Override
    public VaultToken login() {
        return this.createTokenUsingAppRole();
    }

    private VaultToken createTokenUsingAppRole() {
        String roleId = this.getRoleId();
        String secretId = this.getSecretId();
        Map<String, String> login = this.getAppRoleLogin(roleId, secretId);
        try {
            VaultResponse response = (VaultResponse)this.restOperations.postForObject("auth/{mount}/login", login, VaultResponse.class, new Object[]{this.options.getPath()});
            logger.debug((Object)"Login successful using AppRole authentication");
            return LoginTokenUtil.from(response.getAuth());
        }
        catch (HttpStatusCodeException e) {
            throw new VaultException(String.format("Cannot login using AppRole: %s", VaultResponses.getError(e.getResponseBodyAsString())));
        }
    }

    private String getRoleId() {
        String roleId = this.options.getRoleId();
        if (StringUtils.isEmpty((Object)roleId)) {
            try {
                ResponseEntity response = this.restOperations.exchange("auth/{mount}/role/{role}/role-id", HttpMethod.GET, this.createHttpEntityWithToken(), VaultResponse.class, new Object[]{this.options.getPath(), this.options.getAppRole()});
                roleId = (String)((Map)((VaultResponse)response.getBody()).getData()).get("role_id");
            }
            catch (HttpStatusCodeException e) {
                throw new VaultException(String.format("Cannot get Role id using AppRole: %s", VaultResponses.getError(e.getResponseBodyAsString())));
            }
        }
        return roleId;
    }

    private String getSecretId() {
        String secretId = this.options.getSecretId();
        if (StringUtils.isEmpty((Object)secretId) && this.options.getInitialToken() != null) {
            try {
                VaultResponse response = (VaultResponse)this.restOperations.postForObject("auth/{mount}/role/{role}/secret-id", (Object)this.createHttpEntityWithToken(), VaultResponse.class, new Object[]{this.options.getPath(), this.options.getAppRole()});
                secretId = (String)((Map)response.getData()).get("secret_id");
            }
            catch (HttpStatusCodeException e) {
                throw new VaultException(String.format("Cannot get Secret id using AppRole: %s", VaultResponses.getError(e.getResponseBodyAsString())));
            }
        }
        return secretId;
    }

    private HttpEntity createHttpEntityWithToken() {
        HttpHeaders headers = new HttpHeaders();
        headers.set("X-Vault-Token", this.options.getInitialToken().getToken());
        return new HttpEntity(null, (MultiValueMap)headers);
    }

    private Map<String, String> getAppRoleLogin(String roleId, String secretId) {
        HashMap<String, String> login = new HashMap<String, String>();
        login.put("role_id", roleId);
        if (secretId != null) {
            login.put("secret_id", secretId);
        }
        return login;
    }
}

