/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.authentication;

import java.util.Map;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.vault.VaultException;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.LoginToken;
import org.springframework.vault.client.VaultHttpHeaders;
import org.springframework.vault.client.VaultResponses;
import org.springframework.vault.support.VaultResponse;
import org.springframework.vault.support.VaultToken;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestOperations;

public class LoginTokenAdapter
implements ClientAuthentication {
    private final ClientAuthentication delegate;
    private final RestOperations restOperations;

    public LoginTokenAdapter(ClientAuthentication delegate, RestOperations restOperations) {
        Assert.notNull((Object)delegate, (String)"ClientAuthentication delegate must not be null");
        Assert.notNull((Object)restOperations, (String)"RestOperations must not be null");
        this.delegate = delegate;
        this.restOperations = restOperations;
    }

    @Override
    public LoginToken login() throws VaultException {
        return this.augmentWithSelfLookup(this.delegate.login());
    }

    private LoginToken augmentWithSelfLookup(VaultToken token) {
        Map<String, Object> data = this.lookupSelf(token);
        Boolean renewable = (Boolean)data.get("renewable");
        Number ttl = (Number)data.get("ttl");
        if (renewable != null && renewable.booleanValue()) {
            return LoginToken.renewable(token.toCharArray(), ttl == null ? 0L : ttl.longValue());
        }
        return LoginToken.of(token.toCharArray(), ttl == null ? 0L : ttl.longValue());
    }

    private Map<String, Object> lookupSelf(VaultToken token) {
        try {
            ResponseEntity entity = this.restOperations.exchange("auth/token/lookup-self", HttpMethod.GET, new HttpEntity((MultiValueMap)VaultHttpHeaders.from(token)), VaultResponse.class, new Object[0]);
            return (Map)((VaultResponse)entity.getBody()).getData();
        }
        catch (HttpStatusCodeException e) {
            throw new VaultException(String.format("Cannot self-lookup Token from Cubbyhole: %s %s", e.getStatusCode(), VaultResponses.getError(e.getResponseBodyAsString())));
        }
    }
}

