/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.core;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.vault.VaultException;
import org.springframework.vault.client.VaultResponses;
import org.springframework.vault.core.RestOperationsCallback;
import org.springframework.vault.core.VaultOperations;
import org.springframework.vault.core.VaultSysOperations;
import org.springframework.vault.support.VaultHealth;
import org.springframework.vault.support.VaultInitializationRequest;
import org.springframework.vault.support.VaultInitializationResponse;
import org.springframework.vault.support.VaultMount;
import org.springframework.vault.support.VaultResponseSupport;
import org.springframework.vault.support.VaultToken;
import org.springframework.vault.support.VaultUnsealStatus;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestOperations;

public class VaultSysTemplate
implements VaultSysOperations {
    private static final GetUnsealStatus GET_UNSEAL_STATUS = new GetUnsealStatus();
    private static final Seal SEAL = new Seal();
    private static final GetMounts GET_MOUNTS = new GetMounts("sys/mounts");
    private static final GetMounts GET_AUTH_MOUNTS = new GetMounts("sys/auth");
    private static final Health HEALTH = new Health();
    private final VaultOperations vaultOperations;

    public VaultSysTemplate(VaultOperations vaultOperations) {
        Assert.notNull((Object)vaultOperations, (String)"VaultOperations must not be null");
        this.vaultOperations = vaultOperations;
    }

    @Override
    public boolean isInitialized() {
        return this.vaultOperations.doWithVault(new RestOperationsCallback<Boolean>(){

            @Override
            public Boolean doWithRestOperations(RestOperations restOperations) {
                try {
                    Map body = (Map)restOperations.getForObject("sys/init", Map.class, new Object[0]);
                    return (Boolean)body.get("initialized");
                }
                catch (HttpStatusCodeException e) {
                    throw VaultResponses.buildException(e);
                }
            }
        });
    }

    @Override
    public VaultInitializationResponse initialize(final VaultInitializationRequest vaultInitializationRequest) {
        Assert.notNull((Object)vaultInitializationRequest, (String)"VaultInitialization must not be null");
        return this.vaultOperations.doWithVault(new RestOperationsCallback<VaultInitializationResponse>(){

            @Override
            public VaultInitializationResponse doWithRestOperations(RestOperations restOperations) {
                try {
                    ResponseEntity exchange = restOperations.exchange("sys/init", HttpMethod.PUT, new HttpEntity((Object)vaultInitializationRequest), VaultInitializationResponseImpl.class, new Object[0]);
                    return (VaultInitializationResponse)exchange.getBody();
                }
                catch (HttpStatusCodeException e) {
                    throw VaultResponses.buildException(e);
                }
            }
        });
    }

    @Override
    public void seal() {
        this.vaultOperations.doWithSession(SEAL);
    }

    @Override
    public VaultUnsealStatus unseal(final String keyShare) {
        return this.vaultOperations.doWithVault(new RestOperationsCallback<VaultUnsealStatus>(){

            @Override
            public VaultUnsealStatus doWithRestOperations(RestOperations restOperations) {
                ResponseEntity response = restOperations.exchange("sys/unseal", HttpMethod.PUT, new HttpEntity(Collections.singletonMap("key", keyShare)), VaultUnsealStatusImpl.class, new Object[0]);
                return (VaultUnsealStatus)response.getBody();
            }
        });
    }

    @Override
    public VaultUnsealStatus getUnsealStatus() {
        return this.vaultOperations.doWithVault(GET_UNSEAL_STATUS);
    }

    @Override
    public void mount(String path, VaultMount vaultMount) {
        Assert.hasText((String)path, (String)"Path must not be empty");
        Assert.notNull((Object)vaultMount, (String)"VaultMount must not be null");
        this.vaultOperations.write(String.format("sys/mounts/%s", path), vaultMount);
    }

    @Override
    public Map<String, VaultMount> getMounts() {
        return this.vaultOperations.doWithSession(GET_MOUNTS);
    }

    @Override
    public void unmount(String path) {
        Assert.hasText((String)path, (String)"Path must not be empty");
        this.vaultOperations.delete(String.format("sys/mounts/%s", path));
    }

    @Override
    public void authMount(String path, VaultMount vaultMount) throws VaultException {
        Assert.hasText((String)path, (String)"Path must not be empty");
        Assert.notNull((Object)vaultMount, (String)"VaultMount must not be null");
        this.vaultOperations.write(String.format("sys/auth/%s", path), vaultMount);
    }

    @Override
    public Map<String, VaultMount> getAuthMounts() throws VaultException {
        return this.vaultOperations.doWithSession(GET_AUTH_MOUNTS);
    }

    @Override
    public void authUnmount(String path) throws VaultException {
        Assert.hasText((String)path, (String)"Path must not be empty");
        this.vaultOperations.delete(String.format("sys/auth/%s", path));
    }

    @Override
    public VaultHealth health() {
        return this.vaultOperations.doWithVault(HEALTH);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class VaultHealthImpl
    implements VaultHealth {
        private final boolean initialized;
        private final boolean sealed;
        private final boolean standby;
        private final int serverTimeUtc;
        private final String version;

        private VaultHealthImpl(@JsonProperty(value="initialized") boolean initialized, @JsonProperty(value="sealed") boolean sealed, @JsonProperty(value="standby") boolean standby, @JsonProperty(value="server_time_utc") int serverTimeUtc, @JsonProperty(value="version") String version) {
            this.initialized = initialized;
            this.sealed = sealed;
            this.standby = standby;
            this.serverTimeUtc = serverTimeUtc;
            this.version = version;
        }

        @Override
        public boolean isInitialized() {
            return this.initialized;
        }

        @Override
        public boolean isSealed() {
            return this.sealed;
        }

        @Override
        public boolean isStandby() {
            return this.standby;
        }

        @Override
        public int getServerTimeUtc() {
            return this.serverTimeUtc;
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VaultHealthImpl)) {
                return false;
            }
            VaultHealthImpl other = (VaultHealthImpl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isInitialized() != other.isInitialized()) {
                return false;
            }
            if (this.isSealed() != other.isSealed()) {
                return false;
            }
            if (this.isStandby() != other.isStandby()) {
                return false;
            }
            if (this.getServerTimeUtc() != other.getServerTimeUtc()) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        protected boolean canEqual(Object other) {
            return other instanceof VaultHealthImpl;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isInitialized() ? 79 : 97);
            result = result * 59 + (this.isSealed() ? 79 : 97);
            result = result * 59 + (this.isStandby() ? 79 : 97);
            result = result * 59 + this.getServerTimeUtc();
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        public String toString() {
            return "VaultSysTemplate.VaultHealthImpl(initialized=" + this.isInitialized() + ", sealed=" + this.isSealed() + ", standby=" + this.isStandby() + ", serverTimeUtc=" + this.getServerTimeUtc() + ", version=" + this.getVersion() + ")";
        }
    }

    static class VaultUnsealStatusImpl
    implements VaultUnsealStatus {
        private boolean sealed;
        @JsonProperty(value="t")
        private int secretThreshold;
        @JsonProperty(value="n")
        private int secretShares;
        private int progress;

        @Override
        public boolean isSealed() {
            return this.sealed;
        }

        @Override
        public int getSecretThreshold() {
            return this.secretThreshold;
        }

        @Override
        public int getSecretShares() {
            return this.secretShares;
        }

        @Override
        public int getProgress() {
            return this.progress;
        }

        public void setSealed(boolean sealed) {
            this.sealed = sealed;
        }

        public void setSecretThreshold(int secretThreshold) {
            this.secretThreshold = secretThreshold;
        }

        public void setSecretShares(int secretShares) {
            this.secretShares = secretShares;
        }

        public void setProgress(int progress) {
            this.progress = progress;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VaultUnsealStatusImpl)) {
                return false;
            }
            VaultUnsealStatusImpl other = (VaultUnsealStatusImpl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isSealed() != other.isSealed()) {
                return false;
            }
            if (this.getSecretThreshold() != other.getSecretThreshold()) {
                return false;
            }
            if (this.getSecretShares() != other.getSecretShares()) {
                return false;
            }
            return this.getProgress() == other.getProgress();
        }

        protected boolean canEqual(Object other) {
            return other instanceof VaultUnsealStatusImpl;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSealed() ? 79 : 97);
            result = result * 59 + this.getSecretThreshold();
            result = result * 59 + this.getSecretShares();
            result = result * 59 + this.getProgress();
            return result;
        }

        public String toString() {
            return "VaultSysTemplate.VaultUnsealStatusImpl(sealed=" + this.isSealed() + ", secretThreshold=" + this.getSecretThreshold() + ", secretShares=" + this.getSecretShares() + ", progress=" + this.getProgress() + ")";
        }
    }

    static class VaultInitializationResponseImpl
    implements VaultInitializationResponse {
        private List<String> keys = new ArrayList<String>();
        @JsonProperty(value="root_token")
        private String rootToken;

        @Override
        public VaultToken getRootToken() {
            return VaultToken.of(this.rootToken);
        }

        @Override
        public List<String> getKeys() {
            return this.keys;
        }

        public void setKeys(List<String> keys) {
            this.keys = keys;
        }

        public void setRootToken(String rootToken) {
            this.rootToken = rootToken;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VaultInitializationResponseImpl)) {
                return false;
            }
            VaultInitializationResponseImpl other = (VaultInitializationResponseImpl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$keys = this.getKeys();
            List<String> other$keys = other.getKeys();
            if (this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys)) {
                return false;
            }
            VaultToken this$rootToken = this.getRootToken();
            VaultToken other$rootToken = other.getRootToken();
            return !(this$rootToken == null ? other$rootToken != null : !((Object)this$rootToken).equals(other$rootToken));
        }

        protected boolean canEqual(Object other) {
            return other instanceof VaultInitializationResponseImpl;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $keys = this.getKeys();
            result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
            VaultToken $rootToken = this.getRootToken();
            result = result * 59 + ($rootToken == null ? 43 : ((Object)$rootToken).hashCode());
            return result;
        }

        public String toString() {
            return "VaultSysTemplate.VaultInitializationResponseImpl(keys=" + this.getKeys() + ", rootToken=" + this.getRootToken() + ")";
        }
    }

    private static class Health
    implements RestOperationsCallback<VaultHealth> {
        private Health() {
        }

        @Override
        public VaultHealth doWithRestOperations(RestOperations restOperations) {
            try {
                ResponseEntity healthResponse = restOperations.exchange("sys/health", HttpMethod.GET, null, VaultHealthImpl.class, new Object[0]);
                return (VaultHealth)healthResponse.getBody();
            }
            catch (HttpStatusCodeException responseError) {
                try {
                    ObjectMapper mapper = new ObjectMapper();
                    return (VaultHealth)mapper.readValue(responseError.getResponseBodyAsString(), VaultHealthImpl.class);
                }
                catch (Exception jsonError) {
                    throw responseError;
                }
            }
        }
    }

    private static class GetMounts
    implements RestOperationsCallback<Map<String, VaultMount>> {
        private static final ParameterizedTypeReference<VaultMountsResponse> MOUNT_TYPE_REF = new ParameterizedTypeReference<VaultMountsResponse>(){};
        private final String path;

        GetMounts(String path) {
            this.path = path;
        }

        @Override
        public Map<String, VaultMount> doWithRestOperations(RestOperations restOperations) {
            ResponseEntity exchange = restOperations.exchange(this.path, HttpMethod.GET, null, MOUNT_TYPE_REF, Collections.emptyMap());
            VaultMountsResponse body = (VaultMountsResponse)exchange.getBody();
            if (body.getData() != null) {
                return (Map)body.getData();
            }
            return body.getTopLevelMounts();
        }

        private static class VaultMountsResponse
        extends VaultResponseSupport<Map<String, VaultMount>> {
            private Map<String, VaultMount> topLevelMounts = new HashMap<String, VaultMount>();

            private VaultMountsResponse() {
            }

            @JsonIgnore
            public Map<String, VaultMount> getTopLevelMounts() {
                return this.topLevelMounts;
            }

            @JsonAnySetter
            public void set(String name, Object value) {
                Map map;
                if (value instanceof Map && (map = (Map)value).containsKey("type")) {
                    VaultMount vaultMount = VaultMount.builder().type((String)map.get("type")).description((String)map.get("description")).config((Map)map.get("config")).build();
                    this.topLevelMounts.put(name, vaultMount);
                }
            }
        }
    }

    private static class Seal
    implements RestOperationsCallback<Void> {
        private Seal() {
        }

        @Override
        public Void doWithRestOperations(RestOperations restOperations) {
            restOperations.put("sys/seal", null, new Object[0]);
            return null;
        }
    }

    private static class GetUnsealStatus
    implements RestOperationsCallback<VaultUnsealStatus> {
        private GetUnsealStatus() {
        }

        @Override
        public VaultUnsealStatus doWithRestOperations(RestOperations restOperations) {
            return (VaultUnsealStatus)restOperations.getForObject("sys/seal-status", VaultUnsealStatusImpl.class, new Object[0]);
        }
    }
}

