/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.core;

import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.vault.client.VaultResponses;
import org.springframework.vault.core.RestOperationsCallback;
import org.springframework.vault.core.VaultOperations;
import org.springframework.vault.core.VaultTokenOperations;
import org.springframework.vault.support.VaultResponseSupport;
import org.springframework.vault.support.VaultToken;
import org.springframework.vault.support.VaultTokenRequest;
import org.springframework.vault.support.VaultTokenResponse;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestOperations;

public class VaultTokenTemplate
implements VaultTokenOperations {
    private final VaultOperations vaultOperations;

    public VaultTokenTemplate(VaultOperations vaultOperations) {
        Assert.notNull((Object)vaultOperations, (String)"VaultOperations must not be null");
        this.vaultOperations = vaultOperations;
    }

    @Override
    public VaultTokenResponse create() {
        return this.create(VaultTokenRequest.builder().build());
    }

    @Override
    public VaultTokenResponse create(VaultTokenRequest request) {
        Assert.notNull((Object)request, (String)"VaultTokenRequest must not be null");
        return this.write("auth/token/create", request, VaultTokenResponse.class);
    }

    @Override
    public VaultTokenResponse createOrphan() {
        return this.createOrphan(VaultTokenRequest.builder().build());
    }

    @Override
    public VaultTokenResponse createOrphan(VaultTokenRequest request) {
        Assert.notNull((Object)request, (String)"VaultTokenRequest must not be null");
        return this.write("auth/token/create-orphan", request, VaultTokenResponse.class);
    }

    @Override
    public VaultTokenResponse renew(VaultToken vaultToken) {
        Assert.notNull((Object)vaultToken, (String)"VaultToken must not be null");
        return this.write(String.format("auth/token/renew/%s", vaultToken.getToken()), null, VaultTokenResponse.class);
    }

    @Override
    public void revoke(VaultToken vaultToken) {
        Assert.notNull((Object)vaultToken, (String)"VaultToken must not be null");
        this.write(String.format("auth/token/revoke/%s", vaultToken.getToken()), null, VaultTokenResponse.class);
    }

    @Override
    public void revokeOrphan(VaultToken vaultToken) {
        Assert.notNull((Object)vaultToken, (String)"VaultToken must not be null");
        this.write(String.format("auth/token/revoke-orphan/%s", vaultToken.getToken()), null, VaultTokenResponse.class);
    }

    public <T extends VaultResponseSupport<?>> T write(final String path, final Object body, final Class<T> responseType) {
        Assert.hasText((String)path, (String)"Path must not be empty");
        return (T)((VaultResponseSupport)this.vaultOperations.doWithSession(new RestOperationsCallback<T>(){

            @Override
            public T doWithRestOperations(RestOperations restOperations) {
                try {
                    ResponseEntity exchange = restOperations.exchange(path, HttpMethod.POST, new HttpEntity(body), responseType, new Object[0]);
                    return (VaultResponseSupport)exchange.getBody();
                }
                catch (HttpStatusCodeException e) {
                    throw VaultResponses.buildException(e, path);
                }
            }
        }));
    }
}

