/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.core;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.Base64Utils;
import org.springframework.util.StringUtils;
import org.springframework.vault.VaultException;
import org.springframework.vault.core.VaultOperations;
import org.springframework.vault.core.VaultTransitOperations;
import org.springframework.vault.support.Ciphertext;
import org.springframework.vault.support.Plaintext;
import org.springframework.vault.support.RawTransitKey;
import org.springframework.vault.support.TransitKeyType;
import org.springframework.vault.support.VaultDecryptionResult;
import org.springframework.vault.support.VaultEncryptionResult;
import org.springframework.vault.support.VaultResponse;
import org.springframework.vault.support.VaultResponseSupport;
import org.springframework.vault.support.VaultTransitContext;
import org.springframework.vault.support.VaultTransitKey;
import org.springframework.vault.support.VaultTransitKeyConfiguration;
import org.springframework.vault.support.VaultTransitKeyCreationRequest;

public class VaultTransitTemplate
implements VaultTransitOperations {
    private final VaultOperations vaultOperations;
    private final String path;

    public VaultTransitTemplate(VaultOperations vaultOperations, String path) {
        Assert.notNull((Object)vaultOperations, (String)"VaultOperations must not be null");
        Assert.hasText((String)path, (String)"Path must not be empty");
        this.vaultOperations = vaultOperations;
        this.path = path;
    }

    @Override
    public void createKey(String keyName) {
        Assert.hasText((String)keyName, (String)"KeyName must not be empty");
        this.vaultOperations.write(String.format("%s/keys/%s", this.path, keyName), null);
    }

    @Override
    public void createKey(String keyName, VaultTransitKeyCreationRequest createKeyRequest) {
        Assert.hasText((String)keyName, (String)"KeyName must not be empty");
        Assert.notNull((Object)createKeyRequest, (String)"VaultTransitKeyCreationRequest must not be empty");
        this.vaultOperations.write(String.format("%s/keys/%s", this.path, keyName), createKeyRequest);
    }

    @Override
    public List<String> getKeys() {
        VaultResponse response = this.vaultOperations.read(String.format("%s/keys?list=true", this.path));
        return response == null ? Collections.emptyList() : (List)((Map)response.getData()).get("keys");
    }

    @Override
    public void configureKey(String keyName, VaultTransitKeyConfiguration keyConfiguration) {
        Assert.hasText((String)keyName, (String)"KeyName must not be empty");
        Assert.notNull((Object)keyConfiguration, (String)"VaultKeyConfiguration must not be empty");
        this.vaultOperations.write(String.format("%s/keys/%s/config", this.path, keyName), keyConfiguration);
    }

    @Override
    public RawTransitKey exportKey(String keyName, TransitKeyType type) {
        Assert.hasText((String)keyName, (String)"KeyName must not be empty");
        Assert.notNull((Object)((Object)type), (String)"Key type must not be null");
        VaultResponseSupport<RawTransitKeyImpl> result = this.vaultOperations.read(String.format("%s/export/%s/%s", this.path, type.getValue(), keyName), RawTransitKeyImpl.class);
        return result != null ? result.getData() : null;
    }

    @Override
    public VaultTransitKey getKey(String keyName) {
        Assert.hasText((String)keyName, (String)"KeyName must not be empty");
        VaultResponseSupport<VaultTransitKeyImpl> result = this.vaultOperations.read(String.format("%s/keys/%s", this.path, keyName), VaultTransitKeyImpl.class);
        if (result != null) {
            return result.getData();
        }
        return null;
    }

    @Override
    public void deleteKey(String keyName) {
        Assert.hasText((String)keyName, (String)"KeyName must not be empty");
        this.vaultOperations.delete(String.format("%s/keys/%s", this.path, keyName));
    }

    @Override
    public void rotate(String keyName) {
        Assert.hasText((String)keyName, (String)"KeyName must not be empty");
        this.vaultOperations.write(String.format("%s/keys/%s/rotate", this.path, keyName), null);
    }

    @Override
    public String encrypt(String keyName, String plaintext) {
        Assert.hasText((String)keyName, (String)"KeyName must not be empty");
        Assert.notNull((Object)plaintext, (String)"Plaintext must not be null");
        LinkedHashMap<String, String> request = new LinkedHashMap<String, String>();
        request.put("plaintext", Base64Utils.encodeToString((byte[])plaintext.getBytes()));
        return (String)((Map)this.vaultOperations.write(String.format("%s/encrypt/%s", this.path, keyName), request).getData()).get("ciphertext");
    }

    @Override
    public Ciphertext encrypt(String keyName, Plaintext plaintext) {
        Assert.notNull((Object)plaintext, (String)"Plaintext must not be null");
        String ciphertext = this.encrypt(keyName, plaintext.getPlaintext(), plaintext.getContext());
        return VaultTransitTemplate.toCiphertext(ciphertext, plaintext.getContext());
    }

    @Override
    public String encrypt(String keyName, byte[] plaintext, VaultTransitContext transitRequest) {
        Assert.hasText((String)keyName, (String)"KeyName must not be empty");
        Assert.notNull((Object)plaintext, (String)"Plaintext must not be null");
        LinkedHashMap<String, String> request = new LinkedHashMap<String, String>();
        request.put("plaintext", Base64Utils.encodeToString((byte[])plaintext));
        if (transitRequest != null) {
            VaultTransitTemplate.applyTransitOptions(transitRequest, request);
        }
        return (String)((Map)this.vaultOperations.write(String.format("%s/encrypt/%s", this.path, keyName), request).getData()).get("ciphertext");
    }

    @Override
    public List<VaultEncryptionResult> encrypt(String keyName, List<Plaintext> batchRequest) {
        Assert.hasText((String)keyName, (String)"KeyName must not be empty");
        Assert.notEmpty(batchRequest, (String)"BatchRequest must not be null and must have at least one entry");
        ArrayList<LinkedHashMap<String, String>> batch = new ArrayList<LinkedHashMap<String, String>>(batchRequest.size());
        for (Plaintext request : batchRequest) {
            LinkedHashMap<String, String> vaultRequest = new LinkedHashMap<String, String>(2);
            vaultRequest.put("plaintext", Base64Utils.encodeToString((byte[])request.getPlaintext()));
            if (request.getContext() != null) {
                VaultTransitTemplate.applyTransitOptions(request.getContext(), vaultRequest);
            }
            batch.add(vaultRequest);
        }
        VaultResponse vaultResponse = this.vaultOperations.write(String.format("%s/encrypt/%s", this.path, keyName), Collections.singletonMap("batch_input", batch));
        return VaultTransitTemplate.toEncryptionResults(vaultResponse, batchRequest);
    }

    @Override
    public String decrypt(String keyName, String ciphertext) {
        Assert.hasText((String)keyName, (String)"KeyName must not be empty");
        Assert.hasText((String)ciphertext, (String)"Ciphertext must not be empty");
        LinkedHashMap<String, String> request = new LinkedHashMap<String, String>();
        request.put("ciphertext", ciphertext);
        String plaintext = (String)((Map)this.vaultOperations.write(String.format("%s/decrypt/%s", this.path, keyName), request).getData()).get("plaintext");
        return new String(Base64Utils.decodeFromString((String)plaintext));
    }

    @Override
    public Plaintext decrypt(String keyName, Ciphertext ciphertext) {
        Assert.hasText((String)keyName, (String)"Ciphertext must not be null");
        byte[] plaintext = this.decrypt(keyName, ciphertext.getCiphertext(), ciphertext.getContext());
        return Plaintext.of(plaintext).with(ciphertext.getContext());
    }

    @Override
    public byte[] decrypt(String keyName, String ciphertext, VaultTransitContext transitRequest) {
        Assert.hasText((String)keyName, (String)"KeyName must not be empty");
        Assert.hasText((String)ciphertext, (String)"Ciphertext must not be empty");
        LinkedHashMap<String, String> request = new LinkedHashMap<String, String>();
        request.put("ciphertext", ciphertext);
        if (transitRequest != null) {
            VaultTransitTemplate.applyTransitOptions(transitRequest, request);
        }
        String plaintext = (String)((Map)this.vaultOperations.write(String.format("%s/decrypt/%s", this.path, keyName), request).getData()).get("plaintext");
        return Base64Utils.decodeFromString((String)plaintext);
    }

    @Override
    public List<VaultDecryptionResult> decrypt(String keyName, List<Ciphertext> batchRequest) {
        Assert.hasText((String)keyName, (String)"KeyName must not be empty");
        Assert.notEmpty(batchRequest, (String)"BatchRequest must not be null and must have at least one entry");
        ArrayList<LinkedHashMap<String, String>> batch = new ArrayList<LinkedHashMap<String, String>>(batchRequest.size());
        for (Ciphertext request : batchRequest) {
            LinkedHashMap<String, String> vaultRequest = new LinkedHashMap<String, String>(2);
            vaultRequest.put("ciphertext", request.getCiphertext());
            if (request.getContext() != null) {
                VaultTransitTemplate.applyTransitOptions(request.getContext(), vaultRequest);
            }
            batch.add(vaultRequest);
        }
        VaultResponse vaultResponse = this.vaultOperations.write(String.format("%s/decrypt/%s", this.path, keyName), Collections.singletonMap("batch_input", batch));
        return VaultTransitTemplate.toDecryptionResults(vaultResponse, batchRequest);
    }

    @Override
    public String rewrap(String keyName, String ciphertext) {
        Assert.hasText((String)keyName, (String)"KeyName must not be empty");
        Assert.hasText((String)ciphertext, (String)"Ciphertext must not be empty");
        LinkedHashMap<String, String> request = new LinkedHashMap<String, String>();
        request.put("ciphertext", ciphertext);
        return (String)((Map)this.vaultOperations.write(String.format("%s/rewrap/%s", this.path, keyName), request).getData()).get("ciphertext");
    }

    @Override
    public String rewrap(String keyName, String ciphertext, VaultTransitContext transitRequest) {
        Assert.hasText((String)keyName, (String)"KeyName must not be empty");
        Assert.hasText((String)ciphertext, (String)"Ciphertext must not be empty");
        LinkedHashMap<String, String> request = new LinkedHashMap<String, String>();
        request.put("ciphertext", ciphertext);
        if (transitRequest != null) {
            VaultTransitTemplate.applyTransitOptions(transitRequest, request);
        }
        return (String)((Map)this.vaultOperations.write(String.format("%s/rewrap/%s", this.path, keyName), request).getData()).get("ciphertext");
    }

    private static void applyTransitOptions(VaultTransitContext transitRequest, Map<String, String> request) {
        if (transitRequest.getContext() != null) {
            request.put("context", Base64Utils.encodeToString((byte[])transitRequest.getContext()));
        }
        if (transitRequest.getNonce() != null) {
            request.put("nonce", Base64Utils.encodeToString((byte[])transitRequest.getNonce()));
        }
    }

    private static List<VaultEncryptionResult> toEncryptionResults(VaultResponse vaultResponse, List<Plaintext> batchRequest) {
        ArrayList<VaultEncryptionResult> result = new ArrayList<VaultEncryptionResult>(batchRequest.size());
        List<Map<String, String>> batchData = VaultTransitTemplate.getBatchData(vaultResponse);
        for (int i = 0; i < batchRequest.size(); ++i) {
            Map<String, String> data;
            Plaintext plaintext = batchRequest.get(i);
            VaultEncryptionResult encrypted = batchData.size() > i ? (StringUtils.hasText((String)(data = batchData.get(i)).get("error")) ? new VaultEncryptionResult(new VaultException(data.get("error"))) : new VaultEncryptionResult(VaultTransitTemplate.toCiphertext(data.get("ciphertext"), plaintext.getContext()))) : new VaultEncryptionResult(new VaultException("No result for plaintext #" + i));
            result.add(encrypted);
        }
        return result;
    }

    private static List<VaultDecryptionResult> toDecryptionResults(VaultResponse vaultResponse, List<Ciphertext> batchRequest) {
        ArrayList<VaultDecryptionResult> result = new ArrayList<VaultDecryptionResult>(batchRequest.size());
        List<Map<String, String>> batchData = VaultTransitTemplate.getBatchData(vaultResponse);
        for (int i = 0; i < batchRequest.size(); ++i) {
            Ciphertext ciphertext = batchRequest.get(i);
            VaultDecryptionResult encrypted = batchData.size() > i ? VaultTransitTemplate.getDecryptionResult(batchData.get(i), ciphertext) : new VaultDecryptionResult(new VaultException("No result for ciphertext #" + i));
            result.add(encrypted);
        }
        return result;
    }

    private static VaultDecryptionResult getDecryptionResult(Map<String, String> data, Ciphertext ciphertext) {
        if (StringUtils.hasText((String)data.get("error"))) {
            return new VaultDecryptionResult(new VaultException(data.get("error")));
        }
        if (StringUtils.hasText((String)data.get("plaintext"))) {
            byte[] plaintext = Base64Utils.decodeFromString((String)data.get("plaintext"));
            return new VaultDecryptionResult(Plaintext.of(plaintext).with(ciphertext.getContext()));
        }
        return new VaultDecryptionResult(Plaintext.empty().with(ciphertext.getContext()));
    }

    private static Ciphertext toCiphertext(String ciphertext, VaultTransitContext context) {
        return context != null ? Ciphertext.of(ciphertext).with(context) : Ciphertext.of(ciphertext);
    }

    private static List<Map<String, String>> getBatchData(VaultResponse vaultResponse) {
        return (List)((Map)vaultResponse.getData()).get("batch_results");
    }

    static class RawTransitKeyImpl
    implements RawTransitKey {
        private Map<String, String> keys;
        private String name;

        @Override
        public Map<String, String> getKeys() {
            return this.keys;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void setKeys(Map<String, String> keys) {
            this.keys = keys;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RawTransitKeyImpl)) {
                return false;
            }
            RawTransitKeyImpl other = (RawTransitKeyImpl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, String> this$keys = this.getKeys();
            Map<String, String> other$keys = other.getKeys();
            if (this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RawTransitKeyImpl;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, String> $keys = this.getKeys();
            result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "VaultTransitTemplate.RawTransitKeyImpl(keys=" + this.getKeys() + ", name=" + this.getName() + ")";
        }
    }

    static class VaultTransitKeyImpl
    implements VaultTransitKey {
        private String name;
        @JsonProperty(value="cipher_mode")
        private String cipherMode;
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="deletion_allowed")
        private boolean deletionAllowed;
        private boolean derived;
        private boolean exportable;
        private Map<String, Long> keys;
        @JsonProperty(value="latest_version")
        private boolean latestVersion;
        @JsonProperty(value="min_decryption_version")
        private int minDecryptionVersion;
        @JsonProperty(value="min_encryption_version")
        private int minEncryptionVersion;
        @JsonProperty(value="supports_decryption")
        private boolean supportsDecryption;
        @JsonProperty(value="supports_encryption")
        private boolean supportsEncryption;
        @JsonProperty(value="supports_derivation")
        private boolean supportsDerivation;
        @JsonProperty(value="supports_signing")
        private boolean supportsSigning;

        @Override
        public String getType() {
            if (this.type != null) {
                return this.type;
            }
            return this.cipherMode;
        }

        @Override
        public boolean supportsDecryption() {
            return this.isSupportsDecryption();
        }

        @Override
        public boolean supportsEncryption() {
            return this.isSupportsEncryption();
        }

        @Override
        public boolean supportsDerivation() {
            return this.isSupportsDerivation();
        }

        @Override
        public boolean supportsSigning() {
            return this.isSupportsSigning();
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String getCipherMode() {
            return this.cipherMode;
        }

        @Override
        public boolean isDeletionAllowed() {
            return this.deletionAllowed;
        }

        @Override
        public boolean isDerived() {
            return this.derived;
        }

        @Override
        public boolean isExportable() {
            return this.exportable;
        }

        @Override
        public Map<String, Long> getKeys() {
            return this.keys;
        }

        @Override
        public boolean isLatestVersion() {
            return this.latestVersion;
        }

        @Override
        public int getMinDecryptionVersion() {
            return this.minDecryptionVersion;
        }

        @Override
        public int getMinEncryptionVersion() {
            return this.minEncryptionVersion;
        }

        public boolean isSupportsDecryption() {
            return this.supportsDecryption;
        }

        public boolean isSupportsEncryption() {
            return this.supportsEncryption;
        }

        public boolean isSupportsDerivation() {
            return this.supportsDerivation;
        }

        public boolean isSupportsSigning() {
            return this.supportsSigning;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setCipherMode(String cipherMode) {
            this.cipherMode = cipherMode;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setDeletionAllowed(boolean deletionAllowed) {
            this.deletionAllowed = deletionAllowed;
        }

        public void setDerived(boolean derived) {
            this.derived = derived;
        }

        public void setExportable(boolean exportable) {
            this.exportable = exportable;
        }

        public void setKeys(Map<String, Long> keys) {
            this.keys = keys;
        }

        public void setLatestVersion(boolean latestVersion) {
            this.latestVersion = latestVersion;
        }

        public void setMinDecryptionVersion(int minDecryptionVersion) {
            this.minDecryptionVersion = minDecryptionVersion;
        }

        public void setMinEncryptionVersion(int minEncryptionVersion) {
            this.minEncryptionVersion = minEncryptionVersion;
        }

        public void setSupportsDecryption(boolean supportsDecryption) {
            this.supportsDecryption = supportsDecryption;
        }

        public void setSupportsEncryption(boolean supportsEncryption) {
            this.supportsEncryption = supportsEncryption;
        }

        public void setSupportsDerivation(boolean supportsDerivation) {
            this.supportsDerivation = supportsDerivation;
        }

        public void setSupportsSigning(boolean supportsSigning) {
            this.supportsSigning = supportsSigning;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VaultTransitKeyImpl)) {
                return false;
            }
            VaultTransitKeyImpl other = (VaultTransitKeyImpl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$cipherMode = this.getCipherMode();
            String other$cipherMode = other.getCipherMode();
            if (this$cipherMode == null ? other$cipherMode != null : !this$cipherMode.equals(other$cipherMode)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            if (this.isDeletionAllowed() != other.isDeletionAllowed()) {
                return false;
            }
            if (this.isDerived() != other.isDerived()) {
                return false;
            }
            if (this.isExportable() != other.isExportable()) {
                return false;
            }
            Map<String, Long> this$keys = this.getKeys();
            Map<String, Long> other$keys = other.getKeys();
            if (this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys)) {
                return false;
            }
            if (this.isLatestVersion() != other.isLatestVersion()) {
                return false;
            }
            if (this.getMinDecryptionVersion() != other.getMinDecryptionVersion()) {
                return false;
            }
            if (this.getMinEncryptionVersion() != other.getMinEncryptionVersion()) {
                return false;
            }
            if (this.isSupportsDecryption() != other.isSupportsDecryption()) {
                return false;
            }
            if (this.isSupportsEncryption() != other.isSupportsEncryption()) {
                return false;
            }
            if (this.isSupportsDerivation() != other.isSupportsDerivation()) {
                return false;
            }
            return this.isSupportsSigning() == other.isSupportsSigning();
        }

        protected boolean canEqual(Object other) {
            return other instanceof VaultTransitKeyImpl;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $cipherMode = this.getCipherMode();
            result = result * 59 + ($cipherMode == null ? 43 : $cipherMode.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            result = result * 59 + (this.isDeletionAllowed() ? 79 : 97);
            result = result * 59 + (this.isDerived() ? 79 : 97);
            result = result * 59 + (this.isExportable() ? 79 : 97);
            Map<String, Long> $keys = this.getKeys();
            result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
            result = result * 59 + (this.isLatestVersion() ? 79 : 97);
            result = result * 59 + this.getMinDecryptionVersion();
            result = result * 59 + this.getMinEncryptionVersion();
            result = result * 59 + (this.isSupportsDecryption() ? 79 : 97);
            result = result * 59 + (this.isSupportsEncryption() ? 79 : 97);
            result = result * 59 + (this.isSupportsDerivation() ? 79 : 97);
            result = result * 59 + (this.isSupportsSigning() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "VaultTransitTemplate.VaultTransitKeyImpl(name=" + this.getName() + ", cipherMode=" + this.getCipherMode() + ", type=" + this.getType() + ", deletionAllowed=" + this.isDeletionAllowed() + ", derived=" + this.isDerived() + ", exportable=" + this.isExportable() + ", keys=" + this.getKeys() + ", latestVersion=" + this.isLatestVersion() + ", minDecryptionVersion=" + this.getMinDecryptionVersion() + ", minEncryptionVersion=" + this.getMinEncryptionVersion() + ", supportsDecryption=" + this.isSupportsDecryption() + ", supportsEncryption=" + this.isSupportsEncryption() + ", supportsDerivation=" + this.isSupportsDerivation() + ", supportsSigning=" + this.isSupportsSigning() + ")";
        }
    }
}

