/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.core.lease.domain;

import org.springframework.util.Assert;

public class Lease {
    private static final Lease NONE = new Lease(null, 0L, false);
    private final String leaseId;
    private final long leaseDuration;
    private final boolean renewable;

    private Lease(String leaseId, long leaseDuration, boolean renewable) {
        this.leaseId = leaseId;
        this.leaseDuration = leaseDuration;
        this.renewable = renewable;
    }

    public static Lease of(String leaseId, long leaseDuration, boolean renewable) {
        Assert.hasText((String)leaseId, (String)"LeaseId must not be empty");
        return new Lease(leaseId, leaseDuration, renewable);
    }

    public static Lease fromTimeToLive(long leaseDuration) {
        return new Lease(null, leaseDuration, false);
    }

    public static Lease none() {
        return NONE;
    }

    public boolean hasLeaseId() {
        return this.leaseId != null;
    }

    public String getLeaseId() {
        return this.leaseId;
    }

    public long getLeaseDuration() {
        return this.leaseDuration;
    }

    public boolean isRenewable() {
        return this.renewable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Lease)) {
            return false;
        }
        Lease lease = (Lease)o;
        if (this.leaseDuration != lease.leaseDuration) {
            return false;
        }
        if (this.renewable != lease.renewable) {
            return false;
        }
        return this.leaseId != null ? this.leaseId.equals(lease.leaseId) : lease.leaseId == null;
    }

    public int hashCode() {
        int result = this.leaseId != null ? this.leaseId.hashCode() : 0;
        result = 31 * result + (int)(this.leaseDuration ^ this.leaseDuration >>> 32);
        result = 31 * result + (this.renewable ? 1 : 0);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [leaseId='").append(this.leaseId).append('\'');
        sb.append(", leaseDuration=").append(this.leaseDuration);
        sb.append(", renewable=").append(this.renewable);
        sb.append(']');
        return sb.toString();
    }
}

