/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.support;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class JsonMapFlattener {
    private JsonMapFlattener() {
    }

    public static Map<String, String> flatten(Map<String, ? extends Object> inputMap) {
        Assert.notNull(inputMap, (String)"Input Map must not be null");
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
        JsonMapFlattener.doFlatten("", inputMap.entrySet().iterator(), resultMap);
        return resultMap;
    }

    private static void doFlatten(String propertyPrefix, Iterator<? extends Map.Entry<String, ?>> inputMap, Map<String, String> resultMap) {
        if (StringUtils.hasText((String)propertyPrefix)) {
            propertyPrefix = propertyPrefix + ".";
        }
        while (inputMap.hasNext()) {
            Map.Entry<String, ?> entry = inputMap.next();
            JsonMapFlattener.flattenElement(propertyPrefix + entry.getKey(), entry.getValue(), resultMap);
        }
    }

    private static void flattenElement(String propertyPrefix, Object source, Map<String, String> resultMap) {
        if (source instanceof Iterable) {
            JsonMapFlattener.flattenCollection(propertyPrefix, (Iterable)source, resultMap);
            return;
        }
        if (source instanceof Map) {
            JsonMapFlattener.doFlatten(propertyPrefix, ((Map)source).entrySet().iterator(), resultMap);
            return;
        }
        resultMap.put(propertyPrefix, source == null ? null : source.toString());
    }

    private static void flattenCollection(String propertyPrefix, Iterable<Object> iterable, Map<String, String> resultMap) {
        int counter = 0;
        for (Object element : iterable) {
            JsonMapFlattener.flattenElement(propertyPrefix + "[" + counter + "]", element, resultMap);
            ++counter;
        }
    }
}

