/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.support;

import java.util.Arrays;
import org.springframework.util.Assert;
import org.springframework.vault.support.VaultTransitContext;

public class Plaintext {
    private static final Plaintext EMPTY = new Plaintext(new byte[0], VaultTransitContext.empty());
    private final byte[] plaintext;
    private final VaultTransitContext context;

    private Plaintext(byte[] plaintext, VaultTransitContext context) {
        this.plaintext = plaintext;
        this.context = context;
    }

    public static Plaintext empty() {
        return EMPTY;
    }

    public static Plaintext of(byte[] plaintext) {
        Assert.notNull((Object)plaintext, (String)"Plaintext must not be null");
        if (plaintext.length == 0) {
            return Plaintext.empty();
        }
        return new Plaintext(plaintext, null);
    }

    public static Plaintext of(String plaintext) {
        Assert.notNull((Object)plaintext, (String)"Plaintext must not be null");
        if (plaintext.length() == 0) {
            return Plaintext.empty();
        }
        return Plaintext.of(plaintext.getBytes());
    }

    public byte[] getPlaintext() {
        return this.plaintext;
    }

    public VaultTransitContext getContext() {
        return this.context;
    }

    public Plaintext with(VaultTransitContext context) {
        return new Plaintext(this.getPlaintext(), context);
    }

    public String asString() {
        return new String(this.getPlaintext());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Plaintext)) {
            return false;
        }
        Plaintext other = (Plaintext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getPlaintext(), other.getPlaintext())) {
            return false;
        }
        VaultTransitContext this$context = this.getContext();
        VaultTransitContext other$context = other.getContext();
        return !(this$context == null ? other$context != null : !((Object)this$context).equals(other$context));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Plaintext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getPlaintext());
        VaultTransitContext $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        return result;
    }
}

