/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.support;

import java.util.Arrays;

public class VaultTransitContext {
    private static final VaultTransitContext EMPTY = new VaultTransitContext(null, null);
    private final byte[] context;
    private final byte[] nonce;

    VaultTransitContext(byte[] context, byte[] nonce) {
        this.context = context;
        this.nonce = nonce;
    }

    public static VaultTransitRequestBuilder builder() {
        return new VaultTransitRequestBuilder();
    }

    public static VaultTransitContext empty() {
        return EMPTY;
    }

    public byte[] getContext() {
        return this.context;
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VaultTransitContext)) {
            return false;
        }
        VaultTransitContext other = (VaultTransitContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getContext(), other.getContext())) {
            return false;
        }
        return Arrays.equals(this.getNonce(), other.getNonce());
    }

    protected boolean canEqual(Object other) {
        return other instanceof VaultTransitContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getContext());
        result = result * 59 + Arrays.hashCode(this.getNonce());
        return result;
    }

    public static class VaultTransitRequestBuilder {
        private byte[] context;
        private byte[] nonce;

        VaultTransitRequestBuilder() {
        }

        public VaultTransitRequestBuilder context(byte[] context) {
            this.context = context;
            return this;
        }

        public VaultTransitRequestBuilder nonce(byte[] nonce) {
            this.nonce = nonce;
            return this;
        }

        public VaultTransitContext build() {
            return new VaultTransitContext(this.context, this.nonce);
        }
    }
}

