/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.support;

import com.fasterxml.jackson.annotation.JsonProperty;

public class VaultTransitKeyConfiguration {
    @JsonProperty(value="deletion_allowed")
    private final Boolean deletionAllowed;
    @JsonProperty(value="latest_version")
    private final Integer latestVersion;
    @JsonProperty(value="min_decryption_version")
    private final Integer minDecryptionVersion;
    @JsonProperty(value="min_encryption_version")
    private final Integer minEncryptionVersion;

    private VaultTransitKeyConfiguration(Boolean deletionAllowed, Integer latestVersion, Integer minDecryptionVersion, Integer minEncryptionVersion) {
        this.deletionAllowed = deletionAllowed;
        this.latestVersion = latestVersion;
        this.minDecryptionVersion = minDecryptionVersion;
        this.minEncryptionVersion = minEncryptionVersion;
    }

    public static VaultTransitKeyConfigurationBuilder builder() {
        return new VaultTransitKeyConfigurationBuilder();
    }

    public Boolean getDeletionAllowed() {
        return this.deletionAllowed;
    }

    @Deprecated
    public Integer getLatestVersion() {
        return this.latestVersion;
    }

    public Integer getMinDecryptionVersion() {
        return this.minDecryptionVersion;
    }

    public Integer getMinEncryptionVersion() {
        return this.minEncryptionVersion;
    }

    public static class VaultTransitKeyConfigurationBuilder {
        private Boolean deletionAllowed;
        private Integer latestVersion;
        private Integer minDecryptionVersion;
        private Integer minEncryptionVersion;

        VaultTransitKeyConfigurationBuilder() {
        }

        public VaultTransitKeyConfigurationBuilder deletionAllowed(boolean deletionAllowed) {
            this.deletionAllowed = deletionAllowed;
            return this;
        }

        @Deprecated
        public VaultTransitKeyConfigurationBuilder latestVersion(int latestVersion) {
            this.latestVersion = latestVersion;
            return this;
        }

        public VaultTransitKeyConfigurationBuilder minDecryptionVersion(int minDecryptionVersion) {
            this.minDecryptionVersion = minDecryptionVersion;
            return this;
        }

        public VaultTransitKeyConfigurationBuilder minEncryptionVersion(int minEncryptionVersion) {
            this.minEncryptionVersion = minEncryptionVersion;
            return this;
        }

        public VaultTransitKeyConfiguration build() {
            return new VaultTransitKeyConfiguration(this.deletionAllowed, this.latestVersion, this.minDecryptionVersion, this.minEncryptionVersion);
        }
    }
}

