/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.authentication;

import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.vault.support.VaultToken;

public class AppRoleAuthenticationOptions {
    public static final String DEFAULT_APPROLE_AUTHENTICATION_PATH = "approle";
    private final String path;
    private final String roleId;
    private final String secretId;
    private final String appRole;
    private final VaultToken initialToken;

    private AppRoleAuthenticationOptions(String path, String roleId, String secretId, String appRole, VaultToken initialToken) {
        this.path = path;
        this.roleId = roleId;
        this.secretId = secretId;
        this.appRole = appRole;
        this.initialToken = initialToken;
    }

    public static AppRoleAuthenticationOptionsBuilder builder() {
        return new AppRoleAuthenticationOptionsBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getRoleId() {
        return this.roleId;
    }

    public String getSecretId() {
        return this.secretId;
    }

    public String getAppRole() {
        return this.appRole;
    }

    public VaultToken getInitialToken() {
        return this.initialToken;
    }

    public static class AppRoleAuthenticationOptionsBuilder {
        private String path = "approle";
        private String roleId;
        private String secretId;
        private String appRole;
        private VaultToken initialToken;

        AppRoleAuthenticationOptionsBuilder() {
        }

        public AppRoleAuthenticationOptionsBuilder path(String path) {
            Assert.hasText((String)path, (String)"Path must not be empty");
            this.path = path;
            return this;
        }

        public AppRoleAuthenticationOptionsBuilder roleId(String roleId) {
            Assert.hasText((String)roleId, (String)"RoleId must not be empty");
            this.roleId = roleId;
            return this;
        }

        public AppRoleAuthenticationOptionsBuilder secretId(String secretId) {
            Assert.hasText((String)secretId, (String)"SecretId must not be empty");
            this.secretId = secretId;
            return this;
        }

        public AppRoleAuthenticationOptionsBuilder appRole(String appRole) {
            Assert.hasText((String)appRole, (String)"AppRole must not be empty");
            this.appRole = appRole;
            return this;
        }

        public AppRoleAuthenticationOptionsBuilder initialToken(VaultToken initialToken) {
            Assert.notNull((Object)initialToken, (String)"InitialToken must not be null");
            this.initialToken = initialToken;
            return this;
        }

        public AppRoleAuthenticationOptions build() {
            Assert.hasText((String)this.path, (String)"Path must not be empty");
            if (StringUtils.isEmpty((Object)this.roleId) && StringUtils.isEmpty((Object)this.appRole) && this.initialToken == null) {
                throw new IllegalArgumentException("Either roleId (push mode) or appRole/initialToken (pull mode) must be configured for AppRole authentication");
            }
            if (StringUtils.isEmpty((Object)this.roleId)) {
                Assert.notNull((Object)this.appRole, (String)"AppRole authentication configured for pull mode. AppRole must not be null.");
                Assert.notNull((Object)this.initialToken, (String)"AppRole authentication configured for pull mode. InitialToken must not be null (pull mode)");
            }
            return new AppRoleAuthenticationOptions(this.path, this.roleId, this.secretId, this.appRole, this.initialToken);
        }
    }
}

