/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.authentication;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import java.net.URI;
import org.springframework.util.Assert;

public class AwsIamAuthenticationOptions {
    public static final String DEFAULT_AWS_AUTHENTICATION_PATH = "aws";
    private final String path;
    private final AWSCredentialsProvider credentialsProvider;
    private final String role;
    private final String serverName;
    private final URI endpointUri;

    private AwsIamAuthenticationOptions(String path, AWSCredentialsProvider credentialsProvider, String role, String serverName, URI endpointUri) {
        this.path = path;
        this.credentialsProvider = credentialsProvider;
        this.role = role;
        this.serverName = serverName;
        this.endpointUri = endpointUri;
    }

    public static AwsIamAuthenticationOptionsBuilder builder() {
        return new AwsIamAuthenticationOptionsBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public AWSCredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public String getRole() {
        return this.role;
    }

    public String getServerName() {
        return this.serverName;
    }

    public URI getEndpointUri() {
        return this.endpointUri;
    }

    public static class AwsIamAuthenticationOptionsBuilder {
        private String path = "aws";
        private AWSCredentialsProvider credentialsProvider;
        private String role;
        private String serverName;
        private URI endpointUri = URI.create("https://sts.amazonaws.com/");

        AwsIamAuthenticationOptionsBuilder() {
        }

        public AwsIamAuthenticationOptionsBuilder path(String path) {
            Assert.hasText((String)path, (String)"Path must not be empty");
            this.path = path;
            return this;
        }

        public AwsIamAuthenticationOptionsBuilder credentials(AWSCredentials credentials) {
            Assert.notNull((Object)credentials, (String)"Credentials must not be null");
            return this.credentialsProvider((AWSCredentialsProvider)new AWSStaticCredentialsProvider(credentials));
        }

        public AwsIamAuthenticationOptionsBuilder credentialsProvider(AWSCredentialsProvider credentialsProvider) {
            Assert.notNull((Object)credentialsProvider, (String)"AWSCredentialsProvider must not be null");
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        public AwsIamAuthenticationOptionsBuilder role(String role) {
            Assert.hasText((String)role, (String)"Role must not be null or empty");
            this.role = role;
            return this;
        }

        public AwsIamAuthenticationOptionsBuilder serverName(String serverName) {
            Assert.hasText((String)serverName, (String)"Server name must not be null or empty");
            this.serverName = serverName;
            return this;
        }

        public AwsIamAuthenticationOptionsBuilder endpointUri(URI endpointUri) {
            Assert.notNull((Object)endpointUri, (String)"Endpoint URI must not be null");
            this.endpointUri = endpointUri;
            return this;
        }

        public AwsIamAuthenticationOptions build() {
            Assert.state((this.credentialsProvider != null ? 1 : 0) != 0, (String)"Credentials or CredentialProvider must not be null");
            return new AwsIamAuthenticationOptions(this.path, this.credentialsProvider, this.role, this.serverName, this.endpointUri);
        }
    }
}

