/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.authentication;

import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.http.HttpEntity;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.TriggerContext;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.vault.VaultException;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.LoginToken;
import org.springframework.vault.authentication.LoginTokenUtil;
import org.springframework.vault.authentication.SessionManager;
import org.springframework.vault.client.VaultHttpHeaders;
import org.springframework.vault.client.VaultResponses;
import org.springframework.vault.support.VaultResponse;
import org.springframework.vault.support.VaultToken;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestOperations;

public class LifecycleAwareSessionManager
implements SessionManager,
DisposableBean {
    public static final int REFRESH_PERIOD_BEFORE_EXPIRY = 5;
    private static final RefreshTrigger DEFAULT_TRIGGER = new FixedTimeoutRefreshTrigger(5L, TimeUnit.SECONDS);
    private static final Log logger = LogFactory.getLog(LifecycleAwareSessionManager.class);
    private final ClientAuthentication clientAuthentication;
    private final RestOperations restOperations;
    private final TaskScheduler taskScheduler;
    private final RefreshTrigger refreshTrigger;
    private final Object lock = new Object();
    private volatile VaultToken token;

    public LifecycleAwareSessionManager(ClientAuthentication clientAuthentication, TaskScheduler taskScheduler, RestOperations restOperations) {
        this(clientAuthentication, taskScheduler, restOperations, DEFAULT_TRIGGER);
    }

    public LifecycleAwareSessionManager(ClientAuthentication clientAuthentication, TaskScheduler taskScheduler, RestOperations restOperations, RefreshTrigger refreshTrigger) {
        Assert.notNull((Object)clientAuthentication, (String)"ClientAuthentication must not be null");
        Assert.notNull((Object)taskScheduler, (String)"TaskScheduler must not be null");
        Assert.notNull((Object)restOperations, (String)"RestOperations must not be null");
        Assert.notNull((Object)refreshTrigger, (String)"RefreshTrigger must not be null");
        this.clientAuthentication = clientAuthentication;
        this.restOperations = restOperations;
        this.taskScheduler = taskScheduler;
        this.refreshTrigger = refreshTrigger;
    }

    public void destroy() {
        VaultToken token = this.token;
        this.token = null;
        if (token instanceof LoginToken) {
            this.revoke(token);
        }
    }

    private void revoke(VaultToken token) {
        try {
            this.restOperations.postForObject("auth/token/revoke-self", (Object)new HttpEntity((MultiValueMap)VaultHttpHeaders.from(token)), Map.class, new Object[0]);
        }
        catch (HttpStatusCodeException e) {
            logger.warn((Object)String.format("Cannot revoke VaultToken: %s", VaultResponses.getError(e.getResponseBodyAsString())));
        }
        catch (RuntimeException e) {
            logger.warn((Object)"Cannot revoke VaultToken: %s", (Throwable)e);
        }
    }

    protected boolean renewToken() {
        logger.info((Object)"Renewing token");
        VaultToken token = this.token;
        if (token == null) {
            this.getSessionToken();
            return false;
        }
        try {
            VaultResponse vaultResponse = (VaultResponse)this.restOperations.postForObject("auth/token/renew-self", (Object)new HttpEntity((MultiValueMap)VaultHttpHeaders.from(token)), VaultResponse.class, new Object[0]);
            LoginToken renewed = LoginTokenUtil.from(vaultResponse.getAuth());
            long validTtlThreshold = TimeUnit.MILLISECONDS.toSeconds(this.refreshTrigger.getValidTtlThreshold(renewed));
            if (renewed.getLeaseDuration() <= validTtlThreshold) {
                if (logger.isDebugEnabled()) {
                    logger.info((Object)String.format("Token TTL (%s) exceeded validity TTL threshold (%s). Dropping token.", renewed.getLeaseDuration(), validTtlThreshold));
                } else {
                    logger.info((Object)"Token TTL exceeded validity TTL threshold. Dropping token.");
                }
                this.token = null;
                return false;
            }
            this.token = renewed;
            return true;
        }
        catch (HttpStatusCodeException e) {
            logger.debug((Object)String.format("Cannot renew token, resetting token and performing re-login: %s", VaultResponses.getError(e.getResponseBodyAsString())));
            this.token = null;
            if (e.getStatusCode().is4xxClientError()) {
                return false;
            }
            throw new VaultException(String.format("Cannot renew token: %s", VaultResponses.getError(e.getResponseBodyAsString())));
        }
        catch (RuntimeException e) {
            logger.debug((Object)String.format("Cannot renew token, resetting token and performing re-login: %s", e.toString()));
            this.token = null;
            throw new VaultException("Cannot renew token", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VaultToken getSessionToken() {
        if (this.token == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.token == null) {
                    this.token = this.login();
                    if (this.isTokenRenewable()) {
                        this.scheduleRenewal();
                    }
                }
            }
        }
        return this.token;
    }

    protected VaultToken login() {
        return this.clientAuthentication.login();
    }

    protected boolean isTokenRenewable() {
        if (this.token instanceof LoginToken) {
            LoginToken loginToken = (LoginToken)this.token;
            return loginToken.getLeaseDuration() > 0L && loginToken.isRenewable();
        }
        return false;
    }

    private void scheduleRenewal() {
        logger.info((Object)"Scheduling Token renewal");
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    if (LifecycleAwareSessionManager.this.token != null && LifecycleAwareSessionManager.this.isTokenRenewable() && LifecycleAwareSessionManager.this.renewToken()) {
                        LifecycleAwareSessionManager.this.scheduleRenewal();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Cannot renew VaultToken", (Throwable)e);
                }
            }
        };
        VaultToken token = this.token;
        if (token != null) {
            this.taskScheduler.schedule(task, (Trigger)this.createTrigger(token));
        }
    }

    private OneShotTrigger createTrigger(VaultToken token) {
        return new OneShotTrigger(this.refreshTrigger.nextExecutionTime((LoginToken)token));
    }

    public static class FixedTimeoutRefreshTrigger
    implements RefreshTrigger {
        private final long duration;
        private final long validTtlThreshold;
        private final TimeUnit timeUnit;

        public FixedTimeoutRefreshTrigger(long timeout, TimeUnit timeUnit) {
            Assert.isTrue((timeout >= 0L ? 1 : 0) != 0, (String)"Timeout duration must be greater or equal to zero");
            Assert.notNull((Object)((Object)timeUnit), (String)"TimeUnit must not be null");
            this.duration = timeout;
            this.validTtlThreshold = timeUnit.toMillis(this.duration) + 2000L;
            this.timeUnit = timeUnit;
        }

        public FixedTimeoutRefreshTrigger(long timeout, long validTtlThreshold, TimeUnit timeUnit) {
            Assert.isTrue((timeout >= 0L ? 1 : 0) != 0, (String)"Timeout duration must be greater or equal to zero");
            Assert.notNull((Object)((Object)timeUnit), (String)"TimeUnit must not be null");
            this.duration = timeout;
            this.validTtlThreshold = timeUnit.toMillis(validTtlThreshold);
            this.timeUnit = timeUnit;
        }

        @Override
        public Date nextExecutionTime(LoginToken loginToken) {
            long milliseconds = Math.max(TimeUnit.SECONDS.toMillis(1L), TimeUnit.SECONDS.toMillis(loginToken.getLeaseDuration()) - this.timeUnit.toMillis(this.duration));
            return new Date(System.currentTimeMillis() + milliseconds);
        }

        @Override
        public long getValidTtlThreshold(LoginToken loginToken) {
            return this.validTtlThreshold;
        }
    }

    public static interface RefreshTrigger {
        public Date nextExecutionTime(LoginToken var1);

        public long getValidTtlThreshold(LoginToken var1);
    }

    private static class OneShotTrigger
    implements Trigger {
        private final AtomicBoolean fired = new AtomicBoolean();
        private final Date nextExecutionTime;

        public Date nextExecutionTime(TriggerContext triggerContext) {
            if (this.fired.compareAndSet(false, true)) {
                return this.nextExecutionTime;
            }
            return null;
        }

        @ConstructorProperties(value={"nextExecutionTime"})
        public OneShotTrigger(Date nextExecutionTime) {
            this.nextExecutionTime = nextExecutionTime;
        }
    }
}

