/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.authentication;

import org.springframework.util.Assert;
import org.springframework.vault.support.VaultToken;

public class LoginToken
extends VaultToken {
    private final boolean renewable;
    private final long leaseDuration;

    private LoginToken(char[] token, long leaseDurationSeconds, boolean renewable) {
        super(token);
        this.leaseDuration = leaseDurationSeconds;
        this.renewable = renewable;
    }

    public static LoginToken of(String token) {
        Assert.hasText((String)token, (String)"Token must not be empty");
        return LoginToken.of(token, 0L);
    }

    public static LoginToken of(char[] token) {
        return LoginToken.of(token, 0L);
    }

    public static LoginToken of(String token, long leaseDurationSeconds) {
        Assert.hasText((String)token, (String)"Token must not be empty");
        return LoginToken.of(token.toCharArray(), leaseDurationSeconds);
    }

    public static LoginToken of(char[] token, long leaseDurationSeconds) {
        Assert.notNull((Object)token, (String)"Token must not be null");
        Assert.isTrue((token.length > 0 ? 1 : 0) != 0, (String)"Token must not be empty");
        return new LoginToken(token, leaseDurationSeconds, false);
    }

    public static LoginToken renewable(String token, long leaseDurationSeconds) {
        Assert.hasText((String)token, (String)"Token must not be empty");
        return LoginToken.renewable(token.toCharArray(), leaseDurationSeconds);
    }

    public static LoginToken renewable(char[] token, long leaseDurationSeconds) {
        Assert.notNull((Object)token, (String)"Token must not be null");
        Assert.isTrue((token.length > 0 ? 1 : 0) != 0, (String)"Token must not be empty");
        return new LoginToken(token, leaseDurationSeconds, true);
    }

    public long getLeaseDuration() {
        return this.leaseDuration;
    }

    public boolean isRenewable() {
        return this.renewable;
    }

    @Override
    public String toString() {
        return "LoginToken(renewable=" + this.isRenewable() + ", leaseDuration=" + this.getLeaseDuration() + ")";
    }
}

