/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.authentication;

import java.util.Map;
import org.springframework.vault.authentication.LoginToken;

final class LoginTokenUtil {
    static LoginToken from(Map<String, Object> auth) {
        String token = (String)auth.get("client_token");
        Boolean renewable = (Boolean)auth.get("renewable");
        Number leaseDuration = (Number)auth.get("lease_duration");
        if (renewable != null && renewable.booleanValue()) {
            return LoginToken.renewable(token, leaseDuration.longValue());
        }
        if (leaseDuration != null) {
            return LoginToken.of(token, leaseDuration.longValue());
        }
        return LoginToken.of(token);
    }

    private LoginTokenUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

