/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.authentication;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.vault.authentication.AppIdUserIdMechanism;
import org.springframework.vault.authentication.Sha256;

public class MacAddressUserId
implements AppIdUserIdMechanism {
    private static final Method GET_INDEX = ReflectionUtils.findMethod(NetworkInterface.class, (String)"getIndex");
    private final Log log = LogFactory.getLog(MacAddressUserId.class);
    private final String networkInterfaceHint;

    public MacAddressUserId() {
        this("");
    }

    public MacAddressUserId(int networkInterfaceIndex) {
        Assert.isTrue((networkInterfaceIndex >= 0 ? 1 : 0) != 0, (String)"NetworkInterfaceIndex must be greater or equal to 0");
        this.networkInterfaceHint = "" + networkInterfaceIndex;
    }

    public MacAddressUserId(String networkInterfaceName) {
        Assert.notNull((Object)networkInterfaceName, (String)"NetworkInterfaceName must not be null");
        this.networkInterfaceHint = networkInterfaceName;
    }

    @Override
    public String createUserId() {
        try {
            byte[] mac;
            NetworkInterface networkInterface = null;
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            if (StringUtils.hasText((String)this.networkInterfaceHint)) {
                try {
                    networkInterface = MacAddressUserId.getNetworkInterface(Integer.parseInt(this.networkInterfaceHint), interfaces);
                }
                catch (NumberFormatException e) {
                    networkInterface = MacAddressUserId.getNetworkInterface(this.networkInterfaceHint, interfaces);
                }
            }
            if (networkInterface == null) {
                InetAddress localHost;
                if (StringUtils.hasText((String)this.networkInterfaceHint)) {
                    this.log.warn((Object)String.format("Did not find a NetworkInterface applying hint %s", this.networkInterfaceHint));
                }
                if ((networkInterface = NetworkInterface.getByInetAddress(localHost = InetAddress.getLocalHost())) == null || networkInterface.getHardwareAddress() == null) {
                    networkInterface = MacAddressUserId.getNetworkInterfaceWithHardwareAddress(interfaces);
                }
                if (networkInterface == null) {
                    throw new IllegalStateException(String.format("Cannot determine NetworkInterface for %s", localHost));
                }
            }
            if ((mac = networkInterface.getHardwareAddress()) == null) {
                throw new IllegalStateException(String.format("Network interface %s has no hardware address", networkInterface.getName()));
            }
            return Sha256.toSha256(Sha256.toHexString(mac));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static NetworkInterface getNetworkInterface(Number hint, List<NetworkInterface> interfaces) {
        if (interfaces.size() > hint.intValue() && hint.intValue() >= 0) {
            return interfaces.get(hint.intValue());
        }
        return null;
    }

    private static NetworkInterface getNetworkInterface(String hint, List<NetworkInterface> interfaces) {
        for (NetworkInterface anInterface : interfaces) {
            if (!hint.equals(anInterface.getDisplayName()) && !hint.equals(anInterface.getName())) continue;
            return anInterface;
        }
        return null;
    }

    private static NetworkInterface getNetworkInterfaceWithHardwareAddress(List<NetworkInterface> interfaces) throws IOException {
        List<NetworkInterface> networkInterfacesToUse = interfaces;
        if (GET_INDEX != null) {
            networkInterfacesToUse = new ArrayList<NetworkInterface>(interfaces);
            Collections.sort(networkInterfacesToUse, NetworkInterfaceIndexComparator.INSTANCE);
        }
        for (NetworkInterface anInterface : networkInterfacesToUse) {
            byte[] hardwareAddress = anInterface.getHardwareAddress();
            if (hardwareAddress == null) continue;
            return anInterface;
        }
        return null;
    }

    static enum NetworkInterfaceIndexComparator implements Comparator<NetworkInterface>
    {
        INSTANCE;


        @Override
        public int compare(NetworkInterface o1, NetworkInterface o2) {
            try {
                int left = (Integer)GET_INDEX.invoke((Object)o1, new Object[0]);
                int right = (Integer)GET_INDEX.invoke((Object)o2, new Object[0]);
                return left < right ? -1 : (left == right ? 0 : 1);
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot retrieve index from NetworkInterface", e);
            }
        }
    }
}

