/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.client;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.vault.client.SimpleVaultEndpointProvider;
import org.springframework.vault.client.VaultEndpoint;
import org.springframework.vault.client.VaultEndpointProvider;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.DefaultUriTemplateHandler;
import org.springframework.web.util.UriTemplateHandler;

public class VaultClients {
    public static RestTemplate createRestTemplate(VaultEndpoint endpoint, ClientHttpRequestFactory requestFactory) {
        return VaultClients.createRestTemplate(SimpleVaultEndpointProvider.of(endpoint), requestFactory);
    }

    public static RestTemplate createRestTemplate(VaultEndpointProvider endpointProvider, ClientHttpRequestFactory requestFactory) {
        RestTemplate restTemplate = VaultClients.createRestTemplate();
        restTemplate.setRequestFactory(requestFactory);
        restTemplate.setUriTemplateHandler((UriTemplateHandler)VaultClients.createUriTemplateHandler(endpointProvider));
        return restTemplate;
    }

    public static RestTemplate createRestTemplate() {
        ArrayList<Object> messageConverters = new ArrayList<Object>(3);
        messageConverters.add(new ByteArrayHttpMessageConverter());
        messageConverters.add(new StringHttpMessageConverter());
        messageConverters.add(new MappingJackson2HttpMessageConverter());
        RestTemplate restTemplate = new RestTemplate(messageConverters);
        restTemplate.getInterceptors().add(new ClientHttpRequestInterceptor(){

            public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
                return execution.execute(request, body);
            }
        });
        return restTemplate;
    }

    private static DefaultUriTemplateHandler createUriTemplateHandler(VaultEndpointProvider endpointProvider) {
        return new PrefixAwareUriTemplateHandler(endpointProvider);
    }

    public static class PrefixAwareUriTemplateHandler
    extends DefaultUriTemplateHandler {
        private final VaultEndpointProvider endpointProvider;

        public PrefixAwareUriTemplateHandler() {
            this.endpointProvider = null;
        }

        public PrefixAwareUriTemplateHandler(VaultEndpointProvider endpointProvider) {
            this.endpointProvider = endpointProvider;
        }

        public URI expand(String uriTemplate, Map<String, ?> uriVariables) {
            return super.expand(this.prepareUriTemplate(uriTemplate), uriVariables);
        }

        public URI expand(String uriTemplate, Object ... uriVariableValues) {
            return super.expand(this.prepareUriTemplate(uriTemplate), uriVariableValues);
        }

        public String getBaseUrl() {
            if (this.endpointProvider != null) {
                VaultEndpoint endpoint = this.endpointProvider.getVaultEndpoint();
                return endpoint.getScheme() + "://" + endpoint.getHost() + ":" + endpoint.getPort() + "/v1";
            }
            return super.getBaseUrl();
        }

        private String prepareUriTemplate(String uriTemplate) {
            if (uriTemplate.startsWith("http:") || uriTemplate.startsWith("https:")) {
                return uriTemplate;
            }
            if (this.getBaseUrl() != null) {
                if (uriTemplate.startsWith("/") && this.getBaseUrl().endsWith("/")) {
                    return uriTemplate.substring(1);
                }
                if (!uriTemplate.startsWith("/") && !this.getBaseUrl().endsWith("/")) {
                    return "/" + uriTemplate;
                }
                return uriTemplate;
            }
            if (!uriTemplate.startsWith("/")) {
                return "/" + uriTemplate;
            }
            return uriTemplate;
        }
    }
}

