/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.client;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import org.springframework.util.Assert;

public class VaultEndpoint
implements Serializable {
    public static final String API_VERSION = "v1";
    private String host = "localhost";
    private int port = 8200;
    private String scheme = "https";

    public static VaultEndpoint create(String host, int port) {
        Assert.hasText((String)host, (String)"Host must not be empty");
        VaultEndpoint vaultEndpoint = new VaultEndpoint();
        vaultEndpoint.setHost(host);
        vaultEndpoint.setPort(port);
        return vaultEndpoint;
    }

    public static VaultEndpoint from(URI uri) {
        Assert.notNull((Object)uri, (String)"URI must not be null");
        Assert.hasText((String)uri.getScheme(), (String)"Scheme must not be empty");
        Assert.hasText((String)uri.getHost(), (String)"Host must not be empty");
        VaultEndpoint vaultEndpoint = new VaultEndpoint();
        vaultEndpoint.setHost(uri.getHost());
        try {
            vaultEndpoint.setPort(uri.getPort() == -1 ? uri.toURL().getDefaultPort() : uri.getPort());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(String.format("Can't retrieve default port from %s", uri), e);
        }
        vaultEndpoint.setScheme(uri.getScheme());
        return vaultEndpoint;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        Assert.isTrue((port >= 1 && port <= 65535 ? 1 : 0) != 0, (String)"Port must be a valid port in the range between 1 and 65535");
        this.port = port;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        Assert.isTrue(("http".equals(scheme) || "https".equals(scheme) ? 1 : 0) != 0, (String)"Scheme must be http or https");
        this.scheme = scheme;
    }

    public URI createUri(String path) {
        return URI.create(this.createUriString(path));
    }

    public String createUriString(String path) {
        Assert.hasText((String)path, (String)"Path must not be empty");
        return String.format("%s://%s:%s/%s/%s", this.getScheme(), this.getHost(), this.getPort(), API_VERSION, path);
    }

    public String toString() {
        return String.format("%s://%s:%d", this.scheme, this.host, this.port);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VaultEndpoint)) {
            return false;
        }
        VaultEndpoint other = (VaultEndpoint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$scheme = this.getScheme();
        String other$scheme = other.getScheme();
        return !(this$scheme == null ? other$scheme != null : !this$scheme.equals(other$scheme));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VaultEndpoint;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        result = result * 59 + this.getPort();
        String $scheme = this.getScheme();
        result = result * 59 + ($scheme == null ? 43 : $scheme.hashCode());
        return result;
    }
}

