/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.support;

import org.springframework.util.Assert;
import org.springframework.vault.VaultException;

public abstract class AbstractResult<V> {
    private final VaultException exception;

    protected AbstractResult() {
        this.exception = null;
    }

    protected AbstractResult(VaultException exception) {
        Assert.notNull((Object)((Object)exception), (String)"VaultException must not be null");
        this.exception = exception;
    }

    public boolean isSuccessful() {
        return this.exception == null;
    }

    public Exception getCause() {
        return this.exception;
    }

    public V get() {
        if (this.isSuccessful()) {
            return this.get0();
        }
        throw new VaultException(this.exception.getMessage());
    }

    protected abstract V get0();
}

