/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.support;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.KeySpec;
import org.springframework.util.Assert;
import org.springframework.vault.VaultException;
import org.springframework.vault.support.Base64;
import org.springframework.vault.support.KeystoreUtil;

public class CertificateBundle {
    private final String serialNumber;
    private final String certificate;
    private final String issuingCaCertificate;
    private final String privateKey;

    private CertificateBundle(@JsonProperty(value="serial_number") String serialNumber, @JsonProperty(value="certificate") String certificate, @JsonProperty(value="issuing_ca") String issuingCaCertificate, @JsonProperty(value="private_key") String privateKey) {
        this.serialNumber = serialNumber;
        this.certificate = certificate;
        this.issuingCaCertificate = issuingCaCertificate;
        this.privateKey = privateKey;
    }

    public static CertificateBundle of(String serialNumber, String certificate, String issuingCaCertificate, String privateKey) {
        Assert.hasText((String)serialNumber, (String)"Serial number must not be empty");
        Assert.hasText((String)certificate, (String)"Certificate must not be empty");
        Assert.hasText((String)issuingCaCertificate, (String)"Issuing CA certificate must not be empty");
        Assert.hasText((String)privateKey, (String)"Private key must not be empty");
        return new CertificateBundle(serialNumber, certificate, issuingCaCertificate, privateKey);
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public String getIssuingCaCertificate() {
        return this.issuingCaCertificate;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public KeySpec getPrivateKeySpec() {
        try {
            byte[] bytes = Base64.decode(this.getPrivateKey());
            return KeystoreUtil.getRSAKeySpec(bytes);
        }
        catch (IOException e) {
            throw new VaultException("Cannot create KeySpec from private key", e);
        }
    }

    public X509Certificate getX509Certificate() {
        try {
            byte[] bytes = Base64.decode(this.getCertificate());
            return KeystoreUtil.getCertificate(bytes);
        }
        catch (IOException e) {
            throw new VaultException("Cannot create Certificate from certificate", e);
        }
        catch (CertificateException e) {
            throw new VaultException("Cannot create Certificate from certificate", e);
        }
    }

    public X509Certificate getX509IssuerCertificate() {
        try {
            byte[] bytes = Base64.decode(this.getIssuingCaCertificate());
            return KeystoreUtil.getCertificate(bytes);
        }
        catch (IOException e) {
            throw new VaultException("Cannot create Certificate from issuing CA certificate", e);
        }
        catch (CertificateException e) {
            throw new VaultException("Cannot create Certificate from issuing CA certificate", e);
        }
    }

    public KeyStore createKeyStore(String keyAlias) {
        Assert.hasText((String)keyAlias, (String)"Key alias must not be empty");
        try {
            return KeystoreUtil.createKeyStore(keyAlias, this.getPrivateKeySpec(), this.getX509Certificate(), this.getX509IssuerCertificate());
        }
        catch (GeneralSecurityException e) {
            throw new VaultException("Cannot create KeyStore", e);
        }
        catch (IOException e) {
            throw new VaultException("Cannot create KeyStore", e);
        }
    }
}

