/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.support;

import java.security.KeyStore;
import java.util.Arrays;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class SslConfiguration {
    public static final SslConfiguration NONE = new SslConfiguration(KeyStoreConfiguration.EMPTY, KeyStoreConfiguration.EMPTY);
    private final KeyStoreConfiguration keyStoreConfiguration;
    private final KeyStoreConfiguration trustStoreConfiguration;

    @Deprecated
    public SslConfiguration(Resource keyStore, String keyStorePassword, Resource trustStore, String trustStorePassword) {
        this(new KeyStoreConfiguration(keyStore, SslConfiguration.charsOrNull(keyStorePassword), KeyStore.getDefaultType()), new KeyStoreConfiguration(trustStore, SslConfiguration.charsOrNull(trustStorePassword), KeyStore.getDefaultType()));
    }

    public SslConfiguration(KeyStoreConfiguration keyStoreConfiguration, KeyStoreConfiguration trustStoreConfiguration) {
        Assert.notNull((Object)keyStoreConfiguration, (String)"KeyStore configuration must not be null");
        Assert.notNull((Object)trustStoreConfiguration, (String)"TrustStore configuration must not be null");
        this.keyStoreConfiguration = keyStoreConfiguration;
        this.trustStoreConfiguration = trustStoreConfiguration;
    }

    @Deprecated
    public static SslConfiguration forTrustStore(Resource trustStore, String trustStorePassword) {
        return SslConfiguration.forTrustStore(trustStore, SslConfiguration.charsOrNull(trustStorePassword));
    }

    public static SslConfiguration forTrustStore(Resource trustStore, char[] trustStorePassword) {
        Assert.notNull((Object)trustStore, (String)"TrustStore must not be null");
        Assert.notNull((Object)trustStore.exists(), (String)String.format("TrustStore %s does not exist", trustStore));
        return new SslConfiguration(KeyStoreConfiguration.EMPTY, new KeyStoreConfiguration(trustStore, trustStorePassword, KeyStore.getDefaultType()));
    }

    @Deprecated
    public static SslConfiguration forKeyStore(Resource keyStore, String keyStorePassword) {
        return SslConfiguration.forKeyStore(keyStore, SslConfiguration.charsOrNull(keyStorePassword));
    }

    public static SslConfiguration forKeyStore(Resource keyStore, char[] keyStorePassword) {
        Assert.notNull((Object)keyStore, (String)"KeyStore must not be null");
        Assert.notNull((Object)keyStore.exists(), (String)String.format("KeyStore %s does not exist", keyStore));
        return new SslConfiguration(new KeyStoreConfiguration(keyStore, keyStorePassword, KeyStore.getDefaultType()), KeyStoreConfiguration.EMPTY);
    }

    @Deprecated
    public SslConfiguration create(Resource keyStore, String keyStorePassword, Resource trustStore, String trustStorePassword) {
        return this.create(keyStore, SslConfiguration.charsOrNull(keyStorePassword), trustStore, SslConfiguration.charsOrNull(trustStorePassword));
    }

    public SslConfiguration create(Resource keyStore, char[] keyStorePassword, Resource trustStore, char[] trustStorePassword) {
        Assert.notNull((Object)keyStore, (String)"KeyStore must not be null");
        Assert.notNull((Object)keyStore.exists(), (String)String.format("KeyStore %s does not exist", trustStore));
        Assert.notNull((Object)trustStore, (String)"TrustStore must not be null");
        Assert.notNull((Object)trustStore.exists(), (String)String.format("TrustStore %s does not exist", trustStore));
        return new SslConfiguration(new KeyStoreConfiguration(keyStore, keyStorePassword, KeyStore.getDefaultType()), new KeyStoreConfiguration(trustStore, trustStorePassword, KeyStore.getDefaultType()));
    }

    public Resource getKeyStore() {
        return this.keyStoreConfiguration.getResource();
    }

    @Deprecated
    public String getKeyStorePassword() {
        return SslConfiguration.stringOrNull(this.keyStoreConfiguration.getStorePassword());
    }

    public KeyStoreConfiguration getKeyStoreConfiguration() {
        return this.keyStoreConfiguration;
    }

    public Resource getTrustStore() {
        return this.trustStoreConfiguration.getResource();
    }

    @Deprecated
    public String getTrustStorePassword() {
        return SslConfiguration.stringOrNull(this.trustStoreConfiguration.getStorePassword());
    }

    public KeyStoreConfiguration getTrustStoreConfiguration() {
        return this.trustStoreConfiguration;
    }

    private static String stringOrNull(char[] storePassword) {
        return storePassword != null ? new String(storePassword) : null;
    }

    private static char[] charsOrNull(String trustStorePassword) {
        return trustStorePassword == null ? null : trustStorePassword.toCharArray();
    }

    public static class KeyStoreConfiguration {
        public static final KeyStoreConfiguration EMPTY = new KeyStoreConfiguration(null, null, null);
        private final Resource resource;
        private final char[] storePassword;
        private final String storeType;

        public KeyStoreConfiguration(Resource resource, char[] storePassword, String storeType) {
            this.resource = resource;
            this.storeType = storeType;
            this.storePassword = (char[])(storePassword == null ? null : Arrays.copyOf(storePassword, storePassword.length));
        }

        public Resource getResource() {
            return this.resource;
        }

        public char[] getStorePassword() {
            return this.storePassword;
        }

        public String getStoreType() {
            return this.storeType;
        }
    }
}

